package com.artfess.data.manager.impl;

import com.artfess.base.context.BaseContext;
import com.artfess.base.util.AuthenticationUtil;
import com.artfess.data.model.BizDataImport;
import com.artfess.data.dao.BizDataImportDao;
import com.artfess.data.manager.BizDataImportManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.data.vo.SysLogsVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.time.LocalDateTime;
import java.util.List;

/**
 * 基站数据导入 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2024-11-14
 */
@Service
public class BizDataImportManagerImpl extends BaseManagerImpl<BizDataImportDao, BizDataImport> implements BizDataImportManager {

    @Autowired
    private BaseContext baseContext;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void saveList(List<SysLogsVo> list, BizDataImport dataImport) {
        dataImport = new BizDataImport();
        dataImport.setOrgId(baseContext.getCurrentOrgId());
        dataImport.setOrgName(baseContext.getCurrentOrgName());
        dataImport.setExpirationTime(LocalDateTime.now());
        //todo 将导入的日志数据 根据数据情况 执行并保存到对应数据表中
       dataImport.setStatus("1");
       this.save(dataImport);
    }
}
