package com.artfess.examine.model;

import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 人员类别专业岗位中间表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-11-08
 */
@Data
@ApiModel(value="ExamPosSys对象", description="专业岗位中间表")
public class ExamPosSys extends BaseModel<ExamPosSys> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "专业id")
    @TableField("sys_id_")
    private String sysId;

    @ApiModelProperty(value = "岗位id")
    @TableField("pos_id_")
    private String posId;

    @ApiModelProperty(value = "组织id")
    @TableField("org_id_")
    private String orgId;

}
