package com.artfess.examine.manager.impl;

import com.artfess.base.enums.DelStatusEnum;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.BeanUtils;
import com.artfess.examine.dao.ExamMaterialTypeDao;
import com.artfess.examine.manager.ExamMaterialTypeManager;
import com.artfess.examine.model.ExamMaterialType;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 资料分类信息 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-10-19
 */
@Service
public class ExamMaterialTypeManagerImpl extends BaseManagerImpl<ExamMaterialTypeDao, ExamMaterialType> implements ExamMaterialTypeManager {

    @Override
    public List<ExamMaterialType> getTree(ExamMaterialType entity) {
        QueryWrapper<ExamMaterialType> queryWrapper = new QueryWrapper();
        if (StringUtils.isNotBlank(entity.getCode())) {
            queryWrapper.like("code_", entity.getCode());
        }

        if (StringUtils.isNotBlank(entity.getName())) {
            queryWrapper.like("name_", entity.getName());
        }

        queryWrapper.eq("is_dele_", DelStatusEnum.N.getType());
        queryWrapper.orderByDesc("sn_");
        List<ExamMaterialType> sysList = this.baseMapper.selectList(queryWrapper);
        List<ExamMaterialType> tree = BeanUtils.listToTree(sysList);
        return tree;
    }
}
