package com.artfess.examine.dao;

import com.artfess.examine.model.ExamUserRecord;
import com.artfess.examine.vo.*;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 考生考试记录（人员考试成绩） Mapper 接口
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-10-19
 */
public interface ExamUserRecordDao extends BaseMapper<ExamUserRecord> {

    List<QuestionsInfoVo> getQuestionList(@Param("vo") ExamReqVo reqVo);

    List<UserInfoVo> findByPaperId(@Param("paperId") String paperId);

    IPage<ExamUserRecord> myPaper(IPage<ExamUserRecord> convert2IPage, @Param(Constants.WRAPPER) Wrapper<ExamUserRecord> convert2Wrapper);

    IPage<PaperStatisticalVo> paperStatistical(IPage<ExamUserRecord> convert2IPage, @Param(Constants.WRAPPER) Wrapper<ExamUserRecord> convert2Wrapper);

    Integer selectUserCount();


    List<ExamUserRecord> myUserRecord(@Param("userId") String userId);

    IPage<ExamUserRecord> detailPage(IPage<ExamUserRecord> convert2IPage, @Param(Constants.WRAPPER) Wrapper<ExamUserRecord> convert2Wrapper);

    List<ExamUserRecord> getYearUserRecord(@Param("vo") ExamUserRecord userRecord);

    /**
     * 根据用户ID获取年度考核的科目成绩
     *
     * @param userId 用户ID
     * @return 年度考核的科目成绩
     */
    List<YearSubjectScoreVO> getYearSubjectScoreByUserId(@Param("userId") String userId,@Param("year") Integer year);
}
