package com.artfess.data.model;

import com.artfess.base.entity.AutoFillModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * XXX资质及成果表（按年明细记录表）
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 超级管理员
 * @since 2024-12-27
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value="BizUserAchieveDetail对象", description="XXX资质及成果表（按年明细记录表）")
public class BizUserAchieveDetail extends AutoFillModel<BizUserAchieveDetail> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "ID_")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "人员档案ID（外键）")
    @TableField("user_archive_id_")
    private String userArchiveId;

    @ApiModelProperty(value = "人员姓名")
    @TableField("user_name_")
    private String userName;

    @ApiModelProperty(value = "身份证号")
    @TableField("identi_card_")
    private String identiCard;

    @ApiModelProperty(value = "填档年份（格式：2024）")
    @TableField("td_year_")
    private Integer tdYear;

    @ApiModelProperty(value = "专业等级评定")
    @TableField("profession_assess_")
    private String professionAssess;

    @ApiModelProperty(value = "教学能力评定")
    @TableField("teach_assess_")
    private String teachAssess;

    @ApiModelProperty(value = "职业技能鉴定")
    @TableField("vocation_assess_")
    private String vocationAssess;

    @ApiModelProperty(value = "执业资格认证")
    @TableField("practice_assess_")
    private String practiceAssess;

    @ApiModelProperty(value = "XXX成果")
    @TableField("archivement_")
    private String archivement;

    @ApiModelProperty(value = "排序号")
    @TableField("sn_")
    private Integer sn;

    @ApiModelProperty(value = "修改单位")
    @TableField("update_org_id_")
    private String updateOrgId;

}
