package com.artfess.data.manager.impl;

import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.data.dao.BizTrainingDataDao;
import com.artfess.data.manager.BizExamIndexDataManager;
import com.artfess.data.manager.BizTrainingDataManager;
import com.artfess.data.model.BizExamGeneralPlan;
import com.artfess.data.model.BizExamIndexData;
import com.artfess.data.model.BizTrainingData;
import com.artfess.examine.vo.OrgVo;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 训练消耗数据 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2024-11-14
 */
@Service
public class BizTrainingDataManagerImpl extends BaseManagerImpl<BizTrainingDataDao, BizTrainingData> implements BizTrainingDataManager {

    @Autowired
    private BizExamIndexDataManager indexDataManager;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean saveInfo(BizTrainingData t) {
        BizExamIndexData bizExamIndexData = indexDataManager.get(t.getIndexId());
        Assert.notNull(bizExamIndexData, "训练消耗指标不存在");
        if("1".equals(t.getOperateType())) {
            bizExamIndexData.setNumber(t.getNumber().add(bizExamIndexData.getNumber()));
        }else if("2".equals(t.getOperateType())){
            int i = t.getNumber().compareTo(bizExamIndexData.getNumber());
            if(i < 0){
                throw new BaseException("训练消耗指标库存不足，请查看库存进行出库!");
            }
            bizExamIndexData.setNumber(bizExamIndexData.getNumber().subtract(t.getNumber()));
        }
        boolean update = indexDataManager.updateById(bizExamIndexData);
        if(update) {
            return this.save(t);
        }
        return false;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean updateInfo(BizTrainingData t) {
        BizExamIndexData bizExamIndexData = indexDataManager.get(t.getIndexId());
        Assert.notNull(bizExamIndexData, "训练消耗指标不存在");
        if("1".equals(t.getOperateType())) {
            bizExamIndexData.setNumber(t.getNumber().add(bizExamIndexData.getNumber()));
        }else if("2".equals(t.getOperateType())){
            int i = bizExamIndexData.getNumber().compareTo(t.getNumber());
            if(i < 0){
                throw new BaseException("训练消耗指标库存不足，请查看库存进行出库!");
            }
            bizExamIndexData.setNumber(bizExamIndexData.getNumber().subtract(t.getNumber()));
        }
        boolean update = indexDataManager.updateById(bizExamIndexData);
        if(update) {
            return this.updateById(t);
        }
        return false;
    }

    @Override
    public void saveList(List<BizTrainingData> list) {

        List<BizExamIndexData> indexDataList = indexDataManager.list();
        Map<String, BizExamIndexData> indexDataMap = indexDataList.stream().collect(Collectors.toMap(item -> item.getName(), item -> item));
        list.forEach(data -> {
            Assert.hasText(data.getIndexName(), "请填写单位");
            if (!CollectionUtils.isEmpty(indexDataMap) && null != indexDataMap.get(data.getIndexName())) {
                data.setIndexId(indexDataMap.get(data.getIndexName()).getId());
            }
        });
        this.saveBatch(list);
    }

    @Override
    public PageList<BizTrainingData> findByPage(QueryFilter<BizTrainingData> queryFilter) {
        PageBean pageBean = queryFilter.getPageBean();
        IPage<BizTrainingData> result = baseMapper.findByPage(convert2IPage(pageBean), convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<BizTrainingData>(result);
    }
}
