/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.data.controller;

import com.alibaba.fastjson.JSON;
import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.annotation.PowerLogInfo;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.LogType;
import com.artfess.base.enums.OperationType;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.enums.TeachingTypelEnum;
import com.artfess.base.exception.RequiredException;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.PinyinUtil;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.artfess.data.manager.BizTeachingResourcesTypeManager;
import com.artfess.data.model.BizTeachingResourcesType;
import com.artfess.poi.util.ExcelUtils;
import com.artfess.poi.util.FileDownloadUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@Api(tags={"\u8bad\u7ec3\u6570\u636e-\u8bad\u7ec3\u77e5\u8bc6\u5206\u7c7b"})
@RequestMapping(value={"/biz/teachingResources/type/"})
@ApiGroup(group={"group_biz"})
public class BizTeachingResourcesTypeController
extends BaseController<BizTeachingResourcesTypeManager, BizTeachingResourcesType> {
    private static final Logger log = LoggerFactory.getLogger(BizTeachingResourcesTypeController.class);

    @PostMapping(value={"/"})
    @ApiOperation(value="\u6dfb\u52a0\u5b9e\u4f53\u7684\u63a5\u53e3")
    public CommonResult<String> create(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody @Validated(value={AddGroup.class}) BizTeachingResourcesType t) {
        String id = ((BizTeachingResourcesTypeManager)this.baseService).insertTree(t);
        if (!StringUtils.isNotBlank((CharSequence)id)) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return new CommonResult();
    }

    @PutMapping(value={"/"})
    @ApiOperation(value="\u66f4\u65b0\u5b9e\u4f53")
    public CommonResult<String> updateById(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody @Validated(value={UpdateGroup.class}) BizTeachingResourcesType t) {
        BizTeachingResourcesType byId = (BizTeachingResourcesType)((Object)((BizTeachingResourcesTypeManager)this.baseService).getById((Serializable)((Object)t.getId())));
        String id = ((BizTeachingResourcesTypeManager)this.baseService).updateTree(t, byId.getName());
        if (!StringUtils.isNotBlank((CharSequence)id)) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u66f4\u65b0\u5b9e\u4f53\u5931\u8d25");
        }
        return new CommonResult();
    }

    @PostMapping(value={"/getTree"})
    @ApiOperation(value="\u83b7\u53d6\u8bad\u7ec3\u77e5\u8bc6\u5206\u7c7b\u4e0b\u62c9\u6811")
    @PowerLogInfo(logType=LogType.BIZ, operaionType=OperationType.QUERY, description="\u83b7\u53d6\u8bad\u7ec3\u77e5\u8bc6\u5206\u7c7b\u4e0b\u62c9\u6811")
    public CommonResult<String> getTree(@ApiParam(name="model", value="\u83b7\u53d6\u8bad\u7ec3\u77e5\u8bc6\u5206\u7c7b\u4e0b\u62c9\u6811") @RequestBody BizTeachingResourcesType entity) {
        log.info("\u83b7\u53d6\u8bad\u7ec3\u77e5\u8bc6\u5206\u7c7b\u4e0b\u62c9\u6811\u8bf7\u6c42\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)((Object)entity)));
        List<BizTeachingResourcesType> list = ((BizTeachingResourcesTypeManager)this.baseService).getTree(entity);
        return CommonResult.success(list, null);
    }

    @ApiOperation(value="\u5bfc\u5165")
    @PostMapping(value={"/importExcel"})
    public CommonResult<String> importExcel(@RequestParam(value="file") MultipartFile file) {
        try {
            ExcelUtils excelUtil = new ExcelUtils(BizTeachingResourcesType.class);
            List list = excelUtil.importExcel(null, file.getInputStream());
            list.forEach(data -> {
                data.setType(TeachingTypelEnum.getType((String)data.getType()));
                data.setCode(PinyinUtil.getPinYinHeadChar((String)data.getName()));
            });
            ((BizTeachingResourcesTypeManager)this.baseService).saveBatch(list);
            return new CommonResult();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("\u5bfc\u5165\u5931\u8d25," + e.getMessage());
        }
    }

    @ApiOperation(value="\u5bfc\u51fa")
    @PostMapping(value={"/export"})
    public void export(HttpServletResponse response, HttpServletRequest request, @ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<BizTeachingResourcesType> queryFilter) throws Exception {
        PageList page = ((BizTeachingResourcesTypeManager)this.baseService).query(queryFilter);
        ExcelUtils util = new ExcelUtils(BizTeachingResourcesType.class);
        util.exportExcel(response, request, page.getRows(), "\u8bad\u7ec3\u77e5\u8bc6\u5206\u7c7b");
    }

    @ApiOperation(value="\u4e0b\u8f7d\u5bfc\u5165\u6a21\u677f")
    @GetMapping(value={"/downModel"})
    public void downTemplate(HttpServletResponse response) {
        try {
            ClassPathResource classPathResource = new ClassPathResource("model/\u8bad\u7ec3\u77e5\u8bc6\u6570\u636e/\u8bad\u7ec3\u77e5\u8bc6\u5206\u7c7b.xlsx");
            FileDownloadUtil.fileDownload((HttpServletResponse)response, (InputStream)classPathResource.getInputStream(), (String)"\u8bad\u7ec3\u77e5\u8bc6\u5206\u7c7b\u6a21\u677f.xlsx");
        }
        catch (Exception e) {
            response.setCharacterEncoding("utf-8");
            throw new RequiredException("\u4f60\u6240\u4e0b\u8f7d\u7684\u8d44\u6e90\u4e0d\u5b58\u5728");
        }
    }

    @DeleteMapping(value={"/"})
    @ApiOperation(value="\u6839\u636eid\u96c6\u5408\u6279\u91cf\u5220\u9664")
    public CommonResult<String> deleteByIds(String ... ids) {
        boolean result = ((BizTeachingResourcesTypeManager)this.baseService).deleteByIds(Arrays.asList(ids));
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u5220\u9664\u5b9e\u4f53\u5931\u8d25");
        }
        return new CommonResult();
    }
}

