package com.artfess.base.enums;

import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

/**
 *  巡检类型
 */
@Getter
public enum InspectionTypeEnum {
    /**
     *
     */
    ONE("1", "日常"),

    TWO("2", "专项"),

    THREE("3", "其它"),

    ;

    InspectionTypeEnum(String type, String desc){
        this.type = type;
        this.desc = desc;
    }

    private String type;

    private String desc;


    public static String getDesc(String type){
        if(StringUtils.isEmpty(type)){
            return null;
        }
        InspectionTypeEnum[] values = values();
        for (InspectionTypeEnum state : values) {
            if (state.getType().equals(type)) {
                return state.getDesc();
            }
        }
        return null;
    }
}
