package com.artfess.dataShare.scheduler.model;

import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 任务配置表 ---- 系统（自动ETL）任务配置表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author chens
 * @since 2024-12-17
 */
@ApiModel(value="BizSchedulerEtlTask对象", description="任务配置表 ---- 系统（自动ETL）任务配置表")
@TableName("BIZ_SCHEDULER_ETL_TASK")
public class BizSchedulerEtlTask extends BaseModel<BizSchedulerEtlTask> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "调度作业ID（外键）")
    @TableField("JOB_ID_")
    private String jobId;

    @ApiModelProperty(value = "调度作业名称")
    @TableField("JOB_NAME_")
    private String jobName;

    @ApiModelProperty(value = "源头数据源别名 （外键参考数据源表）")
    @TableField("SOURCE_ALIAS_")
    private String sourceAlias;

    @ApiModelProperty(value = "源数据库对象（视图名或表名，逗号隔开）")
    @TableField("SOURCE_TABLE_")
    private String sourceTable;

    @ApiModelProperty(value = "源数据库对象主键字段")
    @TableField("SOURCE_PK_KEY")
    private String sourcePkKey;

    @ApiModelProperty(value = "源表时间戳字段名")
    @TableField("SOURCE_TIMEKEY")
    private String sourceTimekey;

    @ApiModelProperty(value = "时间戳方式-源表时间戳最大值")
    @TableField("MAX_TIMESTAMP_")
    private LocalDateTime maxTimestamp;

    @ApiModelProperty(value = "源数据库抽取SQL语句（可自定义SQL语句）")
    @TableField("SOURCE_SQL_")
    private String sourceSql;

    @ApiModelProperty(value = "目标数据源别名 （外键参考数据源表）")
    @TableField("TARGET_ALIAS_")
    private String targetAlias;

    @ApiModelProperty(value = "目标数据库对象（库表名称）")
    @TableField("TARGET_TABLE_")
    private String targetTable;

    @ApiModelProperty(value = "目标数据库对象主键字段")
    @TableField("TARGET_PK_KEY")
    private String targetPkKey;

    @ApiModelProperty(value = "同步类型（1：完全同步 2：增量同步）")
    @TableField("SYNC_TYPE_")
    private Integer syncType;

    @ApiModelProperty(value = "完全同步方式（1：清空再同步 2：追加同步）")
    @TableField("COM_SYNC_TYPE_")
    private Integer comSyncType;

    @ApiModelProperty(value = "增量同步方式（1：中间表+触发器 2：时间戳）")
    @TableField("INCREMENT_TYPE_")
    private Integer incrementType;

    @ApiModelProperty(value = "触发器方式-数据库字段映射（例如：【原表字段名】-【目标表字段名】）")
    @TableField("MAPPING_")
    private String mapping;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getJobId() {
        return jobId;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public String getJobName() {
        return jobName;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public String getSourceAlias() {
        return sourceAlias;
    }

    public void setSourceAlias(String sourceAlias) {
        this.sourceAlias = sourceAlias;
    }

    public String getSourceTable() {
        return sourceTable;
    }

    public void setSourceTable(String sourceTable) {
        this.sourceTable = sourceTable;
    }

    public String getSourcePkKey() {
        return sourcePkKey;
    }

    public void setSourcePkKey(String sourcePkKey) {
        this.sourcePkKey = sourcePkKey;
    }

    public String getSourceTimekey() {
        return sourceTimekey;
    }

    public void setSourceTimekey(String sourceTimekey) {
        this.sourceTimekey = sourceTimekey;
    }

    public LocalDateTime getMaxTimestamp() {
        return maxTimestamp;
    }

    public void setMaxTimestamp(LocalDateTime maxTimestamp) {
        this.maxTimestamp = maxTimestamp;
    }

    public String getSourceSql() {
        return sourceSql;
    }

    public void setSourceSql(String sourceSql) {
        this.sourceSql = sourceSql;
    }

    public String getTargetAlias() {
        return targetAlias;
    }

    public void setTargetAlias(String targetAlias) {
        this.targetAlias = targetAlias;
    }

    public String getTargetTable() {
        return targetTable;
    }

    public void setTargetTable(String targetTable) {
        this.targetTable = targetTable;
    }

    public String getTargetPkKey() {
        return targetPkKey;
    }

    public void setTargetPkKey(String targetPkKey) {
        this.targetPkKey = targetPkKey;
    }

    public Integer getSyncType() {
        return syncType;
    }

    public void setSyncType(Integer syncType) {
        this.syncType = syncType;
    }

    public Integer getComSyncType() {
        return comSyncType;
    }

    public void setComSyncType(Integer comSyncType) {
        this.comSyncType = comSyncType;
    }

    public Integer getIncrementType() {
        return incrementType;
    }

    public void setIncrementType(Integer incrementType) {
        this.incrementType = incrementType;
    }

    public String getMapping() {
        return mapping;
    }

    public void setMapping(String mapping) {
        this.mapping = mapping;
    }

    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "BizSchedulerEtlTask{" +
            "id=" + id +
            ", jobId=" + jobId +
            ", jobName=" + jobName +
            ", sourceAlias=" + sourceAlias +
            ", sourceTable=" + sourceTable +
            ", sourcePkKey=" + sourcePkKey +
            ", sourceTimekey=" + sourceTimekey +
            ", maxTimestamp=" + maxTimestamp +
            ", sourceSql=" + sourceSql +
            ", targetAlias=" + targetAlias +
            ", targetTable=" + targetTable +
            ", targetPkKey=" + targetPkKey +
            ", syncType=" + syncType +
            ", comSyncType=" + comSyncType +
            ", incrementType=" + incrementType +
            ", mapping=" + mapping +
        "}";
    }
}
