package com.artfess.dataShare.scheduler.manager.impl;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSONObject;
import com.artfess.base.exception.ApplicationException;
import com.artfess.base.exception.RequiredException;
import com.artfess.base.id.IdGenerator;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryField;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.FileUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.dataShare.dataResource.app.dao.BizAppCatalogsTableDao;
import com.artfess.dataShare.dataResource.app.model.BizAppCatalogsTable;
import com.artfess.dataShare.dataResource.dw.dao.BizDwTableDao;
import com.artfess.dataShare.dataResource.dw.model.BizDwdCatalogsTable;
import com.artfess.dataShare.dataResource.ods.dao.BizOdsTableDao;
import com.artfess.dataShare.dataResource.ods.model.BizOdsTable;
import com.artfess.dataShare.dataShare.dao.BizShareTableDao;
import com.artfess.dataShare.dataShare.model.BizShareTable;
import com.artfess.dataShare.scheduler.dao.BizSchedulerJobDao;
import com.artfess.dataShare.scheduler.manager.BizSchedulerEtlTaskManager;
import com.artfess.dataShare.scheduler.manager.BizSchedulerJavaTaskManager;
import com.artfess.dataShare.scheduler.manager.BizSchedulerJobLogManager;
import com.artfess.dataShare.scheduler.manager.BizSchedulerJobManager;
import com.artfess.dataShare.scheduler.manager.BizSchedulerJobTableManager;
import com.artfess.dataShare.scheduler.manager.BizSchedulerKettleTaskManager;
import com.artfess.dataShare.scheduler.manager.BizSchedulerOdsTaskManager;
import com.artfess.dataShare.scheduler.manager.BizSchedulerShellTaskManager;
import com.artfess.dataShare.scheduler.model.BizSchedulerEtlTask;
import com.artfess.dataShare.scheduler.model.BizSchedulerJavaTask;
import com.artfess.dataShare.scheduler.model.BizSchedulerJob;
import com.artfess.dataShare.scheduler.model.BizSchedulerJobLog;
import com.artfess.dataShare.scheduler.model.BizSchedulerJobTable;
import com.artfess.dataShare.scheduler.model.BizSchedulerKettleTask;
import com.artfess.dataShare.scheduler.model.BizSchedulerOdsTask;
import com.artfess.dataShare.scheduler.model.BizSchedulerShellTask;
import com.artfess.file.config.HwObsSetting;
import com.artfess.file.config.MinioSetting;
import com.artfess.file.model.DefaultFile;
import com.artfess.file.util.HuaweiyunOssUtil;
import com.artfess.file.util.MinioUtil;
import com.artfess.sysConfig.util.SysPropertyUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.web.multipart.MultipartFile;

import javax.annotation.Resource;
import java.util.HashMap;
import java.util.List;
import java.util.StringJoiner;

/**
 * 定时任务作业  ---  配置表 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author chens
 * @since 2024-12-16
 */
@Service
public class BizSchedulerJobManagerImpl extends BaseManagerImpl<BizSchedulerJobDao, BizSchedulerJob> implements BizSchedulerJobManager {

    @Autowired
    BizSchedulerJobTableManager jobTableManager;

    @Autowired
    BizSchedulerJobLogManager jobLogManager;

    @Autowired
    BizSchedulerJavaTaskManager javaTaskManager;

    @Autowired
    BizSchedulerKettleTaskManager kettleTaskManager;

    @Autowired
    BizSchedulerShellTaskManager shellTaskManager;

    @Autowired
    BizSchedulerEtlTaskManager etlTaskManager;

    @Autowired
    BizSchedulerOdsTaskManager odsTaskManager;

    @Resource
    BizOdsTableDao odsTableDao;

    @Resource
    BizDwTableDao dwdTableDao;

    @Resource
    BizAppCatalogsTableDao appTableDao;

    @Resource
    BizShareTableDao shareTableDao;

    @Resource
    IdGenerator idGenerator;

    @Value("${dataShare-scheduler.base}")
    private String SCHEDULER_BASE;

    @Override
    public PageList<BizSchedulerJob> sliceQuery(QueryFilter<BizSchedulerJob> queryFilter) {
        PageBean pageBean = queryFilter.getPageBean();
        List<QueryField> list = queryFilter.getQuerys();
        String jobTaskType="";
        String jobTaskMode="";
        if(!CollectionUtils.isEmpty(list)){
            for(QueryField field : list){
                if(field.getProperty().equals("jobTaskType")){
                    jobTaskType = field.getValue().toString();
                }
                if(field.getProperty().equals("jobTaskMode")){
                    jobTaskMode = field.getValue().toString();
                }
            }
        }
        queryFilter.addFilter("j.IS_DELE_", "1", QueryOP.NOT_EQUAL);
        IPage<BizSchedulerJob> result= null;
        if(jobTaskType.equals("1") && !jobTaskMode.equals("5")){
            result=baseMapper.queryCollectPage(convert2IPage(pageBean), convert2Wrapper(queryFilter, currentModelClass()));
        }else if(jobTaskType.equals("2")){
            result=baseMapper.querySharePage(convert2IPage(pageBean), convert2Wrapper(queryFilter, currentModelClass()));
        }else  if(jobTaskType.equals("3")){
            result=baseMapper.queryDwdPage(convert2IPage(pageBean), convert2Wrapper(queryFilter, currentModelClass()));
        }else  if(jobTaskType.equals("4")){
            result=baseMapper.queryAppPage(convert2IPage(pageBean), convert2Wrapper(queryFilter, currentModelClass()));
        }else{
            result=baseMapper.queryPage(convert2IPage(pageBean), convert2Wrapper(queryFilter, currentModelClass()));
        }

        return new PageList<BizSchedulerJob>(result);
    }

    @Override
    @Transactional(rollbackFor = Exception.class )
    public boolean insertSchedulerJob(BizSchedulerJob schedulerJob, MultipartFile[] multipartFiles) {
        if(checkSameName(schedulerJob.getJobName(),schedulerJob.getId())){
            throw new RequiredException("添加失败，该作业【"+schedulerJob.getJobName()+"】在系统中已存在，不能重复！");
        }
        if(schedulerJob.getJobType()==null){
            throw new RequiredException("添加失败，该作业【"+schedulerJob.getJobName()+"】请选择是定时任务还是非定时任务！");
        }
        if(schedulerJob.getJobType()==1 && StringUtil.isEmpty(schedulerJob.getJobCron())){
            throw new RequiredException("添加失败，该定时作业【"+schedulerJob.getJobName()+"】请填写定时计划！");
        }
        String jobId = idGenerator.getSuid();
        schedulerJob.setId(jobId);
        if(schedulerJob.getJobTaskMode()==1){
            if(StringUtil.isEmpty(schedulerJob.getJobClass())){
                throw new RequiredException("添加失败，请添加执行类的类路径！");
            }
        }
        schedulerJob.setIsDele("0");
        schedulerJob.setJobStatus("NONE");
        BizSchedulerJavaTask javaTask = null;
        BizSchedulerKettleTask kettleTask = null;
        BizSchedulerShellTask shellTask = null;
        BizSchedulerEtlTask etlTask =null;
        BizSchedulerOdsTask odsTask =null;
        if(schedulerJob.getJobTaskMode()==1){
            javaTask = schedulerJob.getSchedulerJava();
            if(javaTask==null){
                javaTask = new BizSchedulerJavaTask();
            }
            javaTask.setJobId(jobId);
            javaTask.setJobName(schedulerJob.getJobName());
            if(javaTask.getJarType().equalsIgnoreCase("jar")){
                String className ="com.artfess.scheduler.job.JavaJob";
                schedulerJob.setJobClass(className);
                if(multipartFiles==null){
                    throw new RequiredException("添加失败，请添加JAR文件！");
                }
            }
            if(!javaTask.getJarType().equalsIgnoreCase("jar") && StringUtil.isEmpty(schedulerJob.getJobClass())){
                throw new RequiredException("添加失败，本系统执行需要填写执行类！");
            }
        }else if(schedulerJob.getJobTaskMode()==2){
            String className ="com.artfess.scheduler.job.KettleJob";
            schedulerJob.setJobClass(className);
            if(multipartFiles==null||multipartFiles.length < 2){
                throw new RequiredException("添加失败，请添加kettle的执行文件！");
            }

            kettleTask = schedulerJob.getSchedulerKettle();
            if(kettleTask==null){
                kettleTask = new BizSchedulerKettleTask();
            }
            kettleTask.setJobId(jobId);
            kettleTask.setJobName(schedulerJob.getJobName());
        }else  if(schedulerJob.getJobTaskMode()==3){
            if((multipartFiles==null||multipartFiles.length != 1) && StringUtil.isEmpty(schedulerJob.getSchedulerShell().getCommand())){
                throw new RequiredException("添加失败，请添加Shell命令脚本文件或者命令！");
            }
            String className ="com.artfess.scheduler.job.ShellJob";
            schedulerJob.setJobClass(className);

            shellTask = schedulerJob.getSchedulerShell();
            if(shellTask==null){
                shellTask = new BizSchedulerShellTask();
            }
            shellTask.setJobId(jobId);
            shellTask.setJobName(schedulerJob.getJobName());
        }else  if(schedulerJob.getJobTaskMode()==4){
            String className ="com.artfess.scheduler.job.EtlJob";
            schedulerJob.setJobClass(className);
            etlTask = schedulerJob.getSchedulerEtl();
            if(etlTask==null){
                etlTask = new BizSchedulerEtlTask();
            }
            etlTask.setJobId(jobId);
            etlTask.setJobName(schedulerJob.getJobName());
        }else  if(schedulerJob.getJobTaskMode()==5){
            String className ="com.artfess.scheduler.job.OdsJob";
            schedulerJob.setJobClass(className);
            odsTask = schedulerJob.getSchedulerOds();
            if(odsTask==null){
                odsTask = new BizSchedulerOdsTask();
            }
            odsTask.setJobId(jobId);
            odsTask.setJobName(schedulerJob.getJobName());
        }
        String uploadType = SysPropertyUtil.getByAlias("file.saveType", DefaultFile.SAVE_TYPE_HUAWEIYUN_OBS);
        StringJoiner ktrName = new StringJoiner(";");
        StringJoiner ktrPath = new StringJoiner(";");
        for (MultipartFile multipartFile : multipartFiles) {
            if(StringUtil.isEmpty(uploadType)){
                throw new RequiredException("添加失败，该定时作业【"+schedulerJob.getJobName()+"】请选择上传方式！");
            }
            String fileExt = FileUtil.getFileExt(multipartFile.getOriginalFilename());
            if(schedulerJob.getJobTaskMode()==1 && javaTask.getJarType().equalsIgnoreCase("jar") && !fileExt.toLowerCase().endsWith("jar")){
                throw new ApplicationException("文件格式不正确，请检查后尝试！");
            }
            if(schedulerJob.getJobTaskMode()==2 && (!fileExt.toLowerCase().endsWith("ktr") && !fileExt.toLowerCase().endsWith("kjb"))){
                throw new ApplicationException("文件格式不正确，请检查后尝试！");
            }
            if(schedulerJob.getJobTaskMode()==3 && (!fileExt.toLowerCase().endsWith("sh") && !fileExt.toLowerCase().endsWith("bat"))){
                throw new ApplicationException("文件格式不正确，请检查后尝试！");
            }
            String bizPath = "";
            if(schedulerJob.getJobTaskMode()==1){
                bizPath = "jar/"+ schedulerJob.getJobName();
            }
            if(schedulerJob.getJobTaskMode()==2){
                bizPath = "kettle/"+ schedulerJob.getJobName();
            }
            if(schedulerJob.getJobTaskMode()==3){
                bizPath = "shell/"+ schedulerJob.getJobName();
            }
            try {
                String backUrl ="";
                if(uploadType.equals("minio")){
                    MinioSetting minioSettings = AppUtil.getBean(MinioSetting.class);
                    minioSettings.getMinioClient();
                    backUrl = MinioUtil.upload(multipartFile, bizPath,multipartFile.getOriginalFilename(),"datashare");
                }else if(uploadType.equals("huaweiyunObs")){
                    HwObsSetting hwObsSetting= AppUtil.getBean(HwObsSetting.class);
                    hwObsSetting.initObs();
                    backUrl = HuaweiyunOssUtil.uploadFile(multipartFile,bizPath+ "/"+multipartFile.getOriginalFilename());

                }
                if (StringUtil.isNotBlank(backUrl)) {
                    if(schedulerJob.getJobTaskMode()==1 && javaTask.getJarType().equalsIgnoreCase("jar") && fileExt.toLowerCase().endsWith("jar")){
                        javaTask.setJarName(multipartFile.getOriginalFilename());
                        javaTask.setJarPath(backUrl);
                    }
                    if(schedulerJob.getJobTaskMode()==2){
                        if(fileExt.toLowerCase().endsWith("ktr")){
                            ktrName.add(multipartFile.getOriginalFilename());
                            ktrPath.add(backUrl);
                            kettleTask.setKtrName(ktrName.toString());
                            kettleTask.setKtrPath(ktrPath.toString());
                        }
                        if(fileExt.toLowerCase().endsWith("kjb")){
                            kettleTask.setKjbName(multipartFile.getOriginalFilename());
                            kettleTask.setKjbPath(backUrl);
                        }
                    }
                    if(schedulerJob.getJobTaskMode()==3){
                        if(fileExt.toLowerCase().endsWith("sh") || fileExt.toLowerCase().endsWith("bat")){
                            shellTask.setShellName(multipartFile.getOriginalFilename());
                            shellTask.setShellPath(backUrl);
                        }
                    }
                }else{
                    throw new ApplicationException("脚本上传失败！");
                }
            } catch (Exception e) {
                log.error("上传文件保存错误:", e);
                throw new ApplicationException(e);
            }
        }
        boolean flag= this.save(schedulerJob);
        if((StringUtil.isNotEmpty(schedulerJob.getTableId()) && flag)) {
            BizSchedulerJobTable jobTable = new BizSchedulerJobTable();
            jobTable.setJobId(jobId);
            jobTable.setTableId(schedulerJob.getTableId());
            jobTableManager.create(jobTable);
        }
        if(flag && schedulerJob.getJobTaskMode()==1){
            javaTaskManager.save(javaTask);
        }
        if(flag && schedulerJob.getJobTaskMode()==2){
            kettleTaskManager.save(kettleTask);
        }
        if(flag && schedulerJob.getJobTaskMode()==3){
            shellTaskManager.save(shellTask);
        }
        if(flag && schedulerJob.getJobTaskMode()==4){
            etlTaskManager.save(etlTask);
        }
        if(flag && schedulerJob.getJobTaskMode()==5){
            odsTaskManager.save(odsTask);
        }
        return flag;
    }

    @Override
    @Transactional(rollbackFor = Exception.class )
    public boolean updateSchedulerJob(BizSchedulerJob schedulerJob, MultipartFile[] multipartFiles){
        if (BeanUtils.isNotEmpty(schedulerJob)){
            BizSchedulerJob oldModelTask = this.baseMapper.selectById(schedulerJob.getId());
            if(oldModelTask.getJobType()==1 && oldModelTask.getJobStatus().equals("NORMAL")){
                throw new RequiredException("修改数据抽取任务失败，任务正在运行，请先停止！");
            }
            if(checkSameName(schedulerJob.getJobName(),schedulerJob.getId())){
                throw new RequiredException("修改失败，该作业【"+schedulerJob.getJobName()+"】在系统中已存在，不能重复！");
            }
            BizSchedulerJavaTask javaTask = schedulerJob.getSchedulerJava();
            if(javaTask!=null){
                javaTask.setJobId(schedulerJob.getId());
                javaTask.setJobName(schedulerJob.getJobName());
                if(!javaTask.getJarType().equalsIgnoreCase("jar")){
                    javaTask.setJarType("local");
                    javaTask.setJarName(null);
                    javaTask.setJarPath(null);
                }else{
                    javaTask.setJarType("jar");
                    schedulerJob.setJobClass("com.artfess.scheduler.job.JavaJob");
                }
            }
            BizSchedulerKettleTask kettleTask = schedulerJob.getSchedulerKettle();
            if(kettleTask!=null){
                kettleTask.setJobId(schedulerJob.getId());
                kettleTask.setJobName(schedulerJob.getJobName());
            }
            BizSchedulerShellTask shellTask = schedulerJob.getSchedulerShell();
            if(shellTask!=null){
                shellTask.setJobId(schedulerJob.getId());
                shellTask.setJobName(schedulerJob.getJobName());
            }
            BizSchedulerEtlTask etlTask =schedulerJob.getSchedulerEtl();
            if(etlTask!=null){
                etlTask.setJobId(schedulerJob.getId());
                etlTask.setJobName(schedulerJob.getJobName());
            }
            BizSchedulerOdsTask odsTask =schedulerJob.getSchedulerOds();
            if(odsTask!=null){
                odsTask.setJobId(schedulerJob.getId());
                odsTask.setJobName(schedulerJob.getJobName());
            }


            String uploadType = SysPropertyUtil.getByAlias("file.saveType", DefaultFile.SAVE_TYPE_HUAWEIYUN_OBS);

            //java处理
            if(schedulerJob.getJobTaskMode()==1 && javaTask!=null  && javaTask.getJarType().equalsIgnoreCase("jar") ){
                if(multipartFiles!=null && multipartFiles.length>0){
                    for (MultipartFile multipartFile : multipartFiles) {
                        if(StringUtil.isEmpty(uploadType)){
                            throw new RequiredException("添加失败，该定时作业【"+schedulerJob.getJobName()+"】请选择上传方式！");
                        }
                        String fileExt = FileUtil.getFileExt(multipartFile.getOriginalFilename());
                        if(schedulerJob.getJobTaskMode()==1 && !fileExt.toLowerCase().endsWith("jar")){
                            throw new ApplicationException("文件格式不正确，请检查后尝试！");
                        }
                        String bizPath ="jar/"+ schedulerJob.getJobName();
                        try {
                            String backUrl ="";
                            if(uploadType.equals("minio")){
                                MinioSetting minioSettings = AppUtil.getBean(MinioSetting.class);
                                minioSettings.getMinioClient();
                                backUrl = MinioUtil.upload(multipartFile, bizPath,multipartFile.getOriginalFilename(),"datashare");

                            }else if(uploadType.equals("huaweiyunObs")){
                                HwObsSetting hwObsSetting= AppUtil.getBean(HwObsSetting.class);
                                hwObsSetting.initObs();
                                backUrl = HuaweiyunOssUtil.uploadFile(multipartFile,bizPath+ "/"+multipartFile.getOriginalFilename());
                            }
                            if (StringUtil.isNotBlank(backUrl)) {
                                if(fileExt.toLowerCase().endsWith("jar")){
                                    javaTask.setJarName(multipartFile.getOriginalFilename());
                                    javaTask.setJarPath(backUrl);
                                }
                            }else{
                                throw new ApplicationException("脚本上传失败！");
                            }
                        } catch (Exception e) {
                            log.error("上传文件保存错误:", e);
                            throw new ApplicationException(e);
                        }
                    }
                }
            }

            //kettle任务处理
            if(schedulerJob.getJobTaskMode()==2 && kettleTask!=null ){
                if(multipartFiles!=null && multipartFiles.length >0){
                    StringJoiner ktrName = new StringJoiner(";");
                    if(StringUtil.isNotEmpty(kettleTask.getKtrName())){
                        ktrName.add(kettleTask.getKtrName());
                    }

                    StringJoiner ktrPath = new StringJoiner(";");
                    if(StringUtil.isNotEmpty(kettleTask.getKtrPath())){
                        ktrPath.add(kettleTask.getKtrPath());
                    }

                    for (MultipartFile multipartFile : multipartFiles) {
                        if(StringUtil.isEmpty(uploadType)){
                            throw new RequiredException("添加失败，该定时作业【"+schedulerJob.getJobName()+"】请选择上传方式！");
                        }
                        String fileExt = FileUtil.getFileExt(multipartFile.getOriginalFilename());
                        if(schedulerJob.getJobTaskMode()==2 && (!fileExt.toLowerCase().endsWith("ktr") && !fileExt.toLowerCase().endsWith("kjb"))){
                            throw new ApplicationException("文件格式不正确，请检查后尝试！");
                        }

                        String bizPath = "kettle/"+ schedulerJob.getJobName();
                        try {
                            String backUrl ="";
                            if(uploadType.equals("minio")){
                                MinioSetting minioSettings = AppUtil.getBean(MinioSetting.class);
                                minioSettings.getMinioClient();
                                backUrl = MinioUtil.upload(multipartFile, bizPath,multipartFile.getOriginalFilename(),"datashare");
                            }else if(uploadType.equals("huaweiyunObs")){
                                HwObsSetting hwObsSetting= AppUtil.getBean(HwObsSetting.class);
                                hwObsSetting.initObs();
                                backUrl = HuaweiyunOssUtil.uploadFile(multipartFile,bizPath+ "/"+multipartFile.getOriginalFilename());
                            }
                            if (StringUtil.isNotBlank(backUrl)) {
                                if(fileExt.toLowerCase().endsWith("ktr")){
                                    ktrName.add(multipartFile.getOriginalFilename());
                                    ktrPath.add(backUrl);
                                    kettleTask.setKtrName(ktrName.toString());
                                    kettleTask.setKtrPath(ktrPath.toString());
                                }
                                if(fileExt.toLowerCase().endsWith("kjb")){
                                    kettleTask.setKjbName(multipartFile.getOriginalFilename());
                                    kettleTask.setKjbPath(backUrl);
                                }
                            }else{
                                throw new ApplicationException("脚本上传失败！");
                            }
                        } catch (Exception e) {
                            log.error("上传文件保存错误:", e);
                            throw new ApplicationException(e);
                        }
                    }
                }
            }

            //shell任务处理
            if(schedulerJob.getJobTaskMode()==3 && shellTask!=null ){
                if(multipartFiles!=null && multipartFiles.length>0){
                    for (MultipartFile multipartFile : multipartFiles) {
                        if(StringUtil.isEmpty(uploadType)){
                            throw new RequiredException("添加失败，该定时作业【"+schedulerJob.getJobName()+"】请选择上传方式！");
                        }
                        String fileExt = FileUtil.getFileExt(multipartFile.getOriginalFilename());
                        if(schedulerJob.getJobTaskMode()==3 && (!fileExt.toLowerCase().endsWith("sh") && !fileExt.toLowerCase().endsWith("bat"))){
                            throw new ApplicationException("文件格式不正确，请检查后尝试！");
                        }
                        String bizPath ="shell/"+ schedulerJob.getJobName();
                        try {
                            String backUrl ="";
                            if(uploadType.equals("minio")){
                                MinioSetting minioSettings = AppUtil.getBean(MinioSetting.class);
                                minioSettings.getMinioClient();
                                backUrl = MinioUtil.upload(multipartFile, bizPath,multipartFile.getOriginalFilename(),"datashare");

                            }else if(uploadType.equals("huaweiyunObs")){
                                HwObsSetting hwObsSetting= AppUtil.getBean(HwObsSetting.class);
                                hwObsSetting.initObs();
                                backUrl = HuaweiyunOssUtil.uploadFile(multipartFile,bizPath+ "/"+multipartFile.getOriginalFilename());
                            }
                            if (StringUtil.isNotBlank(backUrl)) {
                                if(fileExt.toLowerCase().endsWith("sh") || fileExt.toLowerCase().endsWith("bat")){
                                    shellTask.setShellName(multipartFile.getOriginalFilename());
                                    shellTask.setShellPath(backUrl);
                                }
                            }else{
                                throw new ApplicationException("脚本上传失败！");
                            }
                        } catch (Exception e) {
                            log.error("上传文件保存错误:", e);
                            throw new ApplicationException(e);
                        }
                    }
                }
            }

            if(schedulerJob.getJobTaskMode()==1 && javaTask!=null){
                javaTaskManager.updateById(javaTask);
            }
            if(schedulerJob.getJobTaskMode()==2 && kettleTask!=null){
                kettleTaskManager.updateById(kettleTask);
            }
            if(schedulerJob.getJobTaskMode()==3 && shellTask!=null){
                shellTaskManager.updateById(shellTask);
            }
            if(schedulerJob.getJobTaskMode()==4 && etlTask!=null){
                etlTaskManager.updateById(etlTask);
            }
            if(schedulerJob.getJobTaskMode()==5 && odsTask!=null){
                odsTaskManager.updateById(odsTask);
            }

            if(StringUtil.isNotEmpty(schedulerJob.gettId()) && StringUtil.isNotEmpty(schedulerJob.getTableId())) {
                UpdateWrapper<BizSchedulerJobTable> updateWrapper =new UpdateWrapper<>();
                updateWrapper.eq("ID_", schedulerJob.gettId());
                updateWrapper.set("JOB_ID_",schedulerJob.getId());
                updateWrapper.set("TABLE_ID_",schedulerJob.getTableId());
                jobTableManager.update(updateWrapper);
            }
            boolean flag = this.delJob(schedulerJob.getId());
            if(flag){
                flag =  this.updateById(schedulerJob);
            }
            return flag;
        }else{
            return false;
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class )
    public boolean deleteSchedulerJobById(String id){
        if(StringUtil.isEmpty(id)){
            throw new RequiredException("删除作业任务失败，请选择要删除的任务！");
        }
        BizSchedulerJob oldSchedulerJob = this.baseMapper.selectById(id);
        if(oldSchedulerJob.getJobType()==1 && oldSchedulerJob.getJobStatus().equals("NORMAL")){
            throw new RequiredException("删除数据抽取任务失败，任务正在运行，请先停止！");
        }
        boolean flag = delJob(id);
        //删除关联表
        if(flag){
            boolean result = this.removeById(id);
            if(result){
                //删除java任务详情
                if(oldSchedulerJob.getJobTaskMode()==1){
                    QueryWrapper<BizSchedulerJavaTask> delJavaWrapper =new QueryWrapper<>();
                    delJavaWrapper.eq("JOB_ID_", id);
                    javaTaskManager.getBaseMapper().delete(delJavaWrapper);
                }
                //删除kettle任务详情
                if(oldSchedulerJob.getJobTaskMode()==2){
                    QueryWrapper<BizSchedulerKettleTask> delKettleWrapper =new QueryWrapper<>();
                    delKettleWrapper.eq("JOB_ID_", id);
                    kettleTaskManager.getBaseMapper().delete(delKettleWrapper);
                }
                //删除shell任务详情
                if(oldSchedulerJob.getJobTaskMode()==3){
                    QueryWrapper<BizSchedulerShellTask> delShellWrapper =new QueryWrapper<>();
                    delShellWrapper.eq("JOB_ID_", id);
                    shellTaskManager.getBaseMapper().delete(delShellWrapper);
                }
                //删除etl任务详情
                if(oldSchedulerJob.getJobTaskMode()==4){
                    QueryWrapper<BizSchedulerEtlTask> delEtlWrapper =new QueryWrapper<>();
                    delEtlWrapper.eq("JOB_ID_", id);
                    etlTaskManager.getBaseMapper().delete(delEtlWrapper);
                }
                //删除ODS任务详情
                if(oldSchedulerJob.getJobTaskMode()==5){
                    QueryWrapper<BizSchedulerOdsTask> delOdsWrapper =new QueryWrapper<>();
                    delOdsWrapper.eq("JOB_ID_", id);
                    odsTaskManager.getBaseMapper().delete(delOdsWrapper);
                }
                //删除关联的数据资源信息
                QueryWrapper<BizSchedulerJobTable> delWrapper =new QueryWrapper<>();
                delWrapper.eq("JOB_ID_", id);
                jobTableManager.getBaseMapper().delete(delWrapper);
                //删除日志
                QueryWrapper<BizSchedulerJobLog> delLogWrapper =new QueryWrapper<>();
                delLogWrapper.eq("JOB_ID_", id);
                jobLogManager.getBaseMapper().delete(delLogWrapper);
            }

        }
        return flag;
    }

    @Override
    public BizSchedulerJob getSchedulerJobById(String id) {
        Assert.hasText(id, "作业任务ID不能为空。");
        BizSchedulerJob schedulerJob = this.baseMapper.selectById(id);

        if(schedulerJob!=null){
            if(schedulerJob.getJobTaskType()==1){
                List<BizOdsTable> list = odsTableDao.queryByJob(schedulerJob.getId());
                if(!CollectionUtils.isEmpty(list)){
                    schedulerJob.setDataResourcesName(list.get(0).getName());
                }
            }else if(schedulerJob.getJobTaskType()==2){
                List<BizShareTable> list = shareTableDao.queryByJob(schedulerJob.getId());
                if(!CollectionUtils.isEmpty(list)){
                    schedulerJob.setDataResourcesName(list.get(0).getName());
                }
            }else if(schedulerJob.getJobTaskType()==3){
                List<BizDwdCatalogsTable> list = dwdTableDao.queryByJob(schedulerJob.getId());
                if(!CollectionUtils.isEmpty(list)){
                    schedulerJob.setDataResourcesName(list.get(0).getName());
                }
            }else if(schedulerJob.getJobTaskType()==4){
                List<BizAppCatalogsTable> list = appTableDao.queryByJob(schedulerJob.getId());
                if(!CollectionUtils.isEmpty(list)){
                    schedulerJob.setDataResourcesName(list.get(0).getName());
                }
            }

            //查询java任务详情
            if(schedulerJob.getJobTaskMode()==1){
                QueryWrapper<BizSchedulerJavaTask> queryJavaWrapper =new QueryWrapper<>();
                queryJavaWrapper.eq("JOB_ID_", id);
                List<BizSchedulerJavaTask> javaTaskList = javaTaskManager.getBaseMapper().selectList(queryJavaWrapper);
                if(!CollectionUtils.isEmpty(javaTaskList)){
                    BizSchedulerJavaTask javaTask = javaTaskList.get(0);
                    schedulerJob.setSchedulerJava(javaTask);
                }
            }
            //查询kettle任务详情
            if(schedulerJob.getJobTaskMode()==2){
                QueryWrapper<BizSchedulerKettleTask> queryKettleWrapper =new QueryWrapper<>();
                queryKettleWrapper.eq("JOB_ID_", id);
                List<BizSchedulerKettleTask> kettleTaskList = kettleTaskManager.getBaseMapper().selectList(queryKettleWrapper);
                if(!CollectionUtils.isEmpty(kettleTaskList)){
                    BizSchedulerKettleTask kettleTask = kettleTaskList.get(0);
                    schedulerJob.setSchedulerKettle(kettleTask);
                }
            }
            //查询shell任务详情
            if(schedulerJob.getJobTaskMode()==3){
                QueryWrapper<BizSchedulerShellTask> queryShellWrapper =new QueryWrapper<>();
                queryShellWrapper.eq("JOB_ID_", id);
                List<BizSchedulerShellTask> shellTaskList = shellTaskManager.getBaseMapper().selectList(queryShellWrapper);
                if(!CollectionUtils.isEmpty(shellTaskList)){
                    BizSchedulerShellTask shellTask = shellTaskList.get(0);
                    schedulerJob.setSchedulerShell(shellTask);
                }
            }
            //查询etl任务详情
            if(schedulerJob.getJobTaskMode()==4){
                QueryWrapper<BizSchedulerEtlTask> queryEtlWrapper =new QueryWrapper<>();
                queryEtlWrapper.eq("JOB_ID_", id);
                List<BizSchedulerEtlTask> etlTaskList = etlTaskManager.getBaseMapper().selectList(queryEtlWrapper);
                if(!CollectionUtils.isEmpty(etlTaskList)){
                    BizSchedulerEtlTask etlTask = etlTaskList.get(0);
                    schedulerJob.setSchedulerEtl(etlTask);
                }
            }
            if(schedulerJob.getJobTaskMode()==5){
                QueryWrapper<BizSchedulerOdsTask> queryOdsWrapper =new QueryWrapper<>();
                queryOdsWrapper.eq("JOB_ID_", id);
                List<BizSchedulerOdsTask> odsTaskList = odsTaskManager.getBaseMapper().selectList(queryOdsWrapper);
                if(!CollectionUtils.isEmpty(odsTaskList)){
                    BizSchedulerOdsTask odsTask = odsTaskList.get(0);
                    schedulerJob.setSchedulerOds(odsTask);
                }
            }
            //查询关联的数据资源项信息
            QueryWrapper<BizSchedulerJobTable> queryJobTableWrapper =new QueryWrapper<>();
            queryJobTableWrapper.eq("JOB_ID_", id);
            List<BizSchedulerJobTable> jobTableList= jobTableManager.getBaseMapper().selectList(queryJobTableWrapper);
            if(!CollectionUtils.isEmpty(jobTableList)){
                BizSchedulerJobTable jobTable = jobTableList.get(0);
                schedulerJob.setTableId(jobTable.getTableId());
                schedulerJob.settId(jobTable.getId());
            }
        }
        return schedulerJob;
    }

    @Override
    public boolean startUpJob(String jobId) {
        HashMap<String, Object> paramMap = new HashMap<>();
        paramMap.put("id", jobId);
        String result= HttpUtil.post(SCHEDULER_BASE+"/dataJob/biz/scheduler/schedulerJob/v1/startUpJob", paramMap);
        if(StringUtil.isNotEmpty(result)){
            JSONObject jsonResp =JSONObject.parseObject(result);
            if(jsonResp.getBoolean("state")){
                return true;
            }else{
                String msg = jsonResp.getString("message");
                throw new RuntimeException("请求失败:<br>"+msg);
            }
        }else{
            return false;
        }
    }

    @Override
    public boolean stopJob(String jobId) {
        HashMap<String, Object> paramMap = new HashMap<>();
        paramMap.put("id", jobId);
        String result= HttpUtil.post(SCHEDULER_BASE+"/dataJob/biz/scheduler/schedulerJob/v1/stopJob", paramMap);
        if(StringUtil.isNotEmpty(result)){
            JSONObject jsonResp =JSONObject.parseObject(result);
            if(jsonResp.getBoolean("state")){
                return true;
            }else{
                String msg = jsonResp.getString("message");
                throw new RuntimeException("请求失败:<br>"+msg);
            }
        }else{
            return false;
        }
    }

    @Override
    public boolean delJob(String jobId) {
        HashMap<String, Object> paramMap = new HashMap<>();
        paramMap.put("id", jobId);
        String result= HttpUtil.post(SCHEDULER_BASE+"/dataJob/biz/scheduler/schedulerJob/v1/delJob", paramMap);
        if(StringUtil.isNotEmpty(result)){
            JSONObject jsonResp =JSONObject.parseObject(result);
            if(jsonResp.getBoolean("state")){
                return true;
            }else{
                String msg = jsonResp.getString("message");
                throw new RuntimeException("请求失败:<br>"+msg);
            }
        }else{
            return false;
        }
    }

    @Override
    public boolean executeJob(String jobId) {
        HashMap<String, Object> paramMap = new HashMap<>();
        paramMap.put("id", jobId);
        String result= HttpUtil.post(SCHEDULER_BASE+"/dataJob/biz/scheduler/schedulerJob/v1/executeJob", paramMap);
        if(StringUtil.isNotEmpty(result)){
            JSONObject jsonResp =JSONObject.parseObject(result);
            if(jsonResp.getBoolean("state")){
                return true;
            }else{
                String msg = jsonResp.getString("message");
                throw new RuntimeException("请求失败:<br>"+msg);
            }
        }else{
            return false;
        }
    }

    @Override
    public boolean validClass(String className) {
        HashMap<String, Object> paramMap = new HashMap<>();
        paramMap.put("className", className);
        String result= HttpUtil.post(SCHEDULER_BASE+"/dataJob/biz/scheduler/schedulerJob/v1/validClass", paramMap);
        if(StringUtil.isNotEmpty(result)){
            JSONObject jsonResp =JSONObject.parseObject(result);
            if(jsonResp.getBoolean("state")){
                return true;
            }else{
                String msg = jsonResp.getString("message");
                throw new RuntimeException("请求失败:<br>"+msg);
            }
        }else{
            return false;
        }
    }

    private boolean checkSameName(String jobName,String id){
        Assert.hasText(jobName, "作业任务名称不能为空。");
        QueryWrapper<BizSchedulerJob> queryWrapper = new QueryWrapper<BizSchedulerJob>();
        queryWrapper.eq( "JOB_NAME_", jobName);
        queryWrapper.ne(StringUtil.isNotEmpty(id), "ID_", id);
        int num = this.baseMapper.selectCount(queryWrapper);
        if(num != 0){
            return true;
        }else {
            return false;
        }
    }
}
