package com.artfess.dataShare.factory;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.jdbc.core.JdbcTemplate;

import java.util.Map;

@Data
@ApiModel("通用数据查询对象类")
public class QueryParamVo {

    @ApiModelProperty("操作的表Id")
    private String tableId;

    @ApiModelProperty("操作的表name")
    private String tableName;

    @ApiModelProperty("查询条件")
    private Map<String,String> param;

    @ApiModelProperty("排序字段和排序类型")
    private String order;

    @ApiModelProperty("当前页数")
    private Integer pageNo=1;

    @ApiModelProperty("每页条数")
    private Integer pageSize=10;
}
