package com.artfess.dataShare.dataResource.ods.manager;

import com.artfess.dataShare.dataResource.ods.model.BizOdsTable;
import com.artfess.base.manager.BaseManager;
import com.artfess.dataShare.dataResource.ods.vo.CatalogTableVo;
import com.artfess.dataShare.dataResource.ods.vo.OdsTableDetailVo;
import com.artfess.dataShare.factory.QueryParamVo;
import com.artfess.dataShare.factory.QueryResultData;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;

/**
 * 数据资源--ODS数据项信息 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author WH
 * @since 2024-11-13
 */
public interface BizOdsTableManager extends BaseManager<BizOdsTable> {

    /**
     * 导入表结构
     * @param file
     * @throws Exception
     */
    void export(MultipartFile file,String catalogId) throws Exception;

    /**
     * 从交换库里面选择表，把模型和字段创建到ODS库
     * @param catalogId 目录ID
     * @param tableId 表ID
     */
    void saveTable(String catalogId,String tableId) throws Exception;

    /**
     * 批量创建到ODS库
     * @param list
     * @return
     */
    boolean saveTableBatch(List<CatalogTableVo> list) throws Exception;

    /**
     * 发布的时候建表
     */
    void Deploy(String tableId) throws Exception;

    /**
     * 根据表查询表信息、字段信息、模型
     * @return
     * @throws Exception
     */
    OdsTableDetailVo queryTableVo(String tableId) throws Exception;

    /**
     * 下载用于导入bo主表的excel模板
     *
     * @param response
     * @param tableId    数据模板的别名
     * @throws IOException
     * @throws Exception
     */
    void downloadMainTempFile(HttpServletResponse response, String tableId) throws IOException, Exception;

    /**
     * 导入主表数据
     *
     * @throws Exception
     */
    void importMain(MultipartFile file, String tableId) throws Exception;

    /**
     * 查询所有发布了的表
     * @return
     */
    List<BizOdsTable> queryDeployed();

    /**
     * 数据查询  分页，加搜索、排序
     * @param queryParam
     * @return
     * @throws Exception
     */
    QueryResultData queryTableData (QueryParamVo queryParam) throws Exception;

    /**
     * 如果表已经创建同步删除实体表
     * @param tableId
     */
    void removeTable(String tableId) throws Exception;

    /**
     *  已有表发布
     * @param tableId 表ID
     * @throws Exception
     */
    void deployHaveTable(String tableId) throws Exception;

    /**
     *  未有表发布
     * @param tableId 表ID
     * @param tableSql 建表语句
     * @throws Exception
     */
    void deployDotHaveTable(String tableId,String tableSql) throws Exception;

    /**
     * 验证表示已经创建
     * @param tableNameEn
     * @return
     * @throws Exception
     */
    boolean checkTableExists(String tableNameEn) throws Exception;

    /**
     * 验证物理表是否已经存在
     * @param tableNameEn
     * @return
     */
    boolean checkPhysicsTableExists(String tableNameEn) throws Exception;

    /**
     * 修改表资源目录
     * @param ids
     * @param catalogId
     * @return
     */
    boolean updateCatalog(String[] ids, String catalogId);
}
