package com.artfess.dataShare.dataResource.ods.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.model.CommonResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.artfess.base.controller.BaseController;
import com.artfess.dataShare.dataResource.ods.model.BizSchedulerCollectDay;
import com.artfess.dataShare.dataResource.ods.manager.BizSchedulerCollectDayManager;

/**
 * 数据采集每日数据采集量汇总统计记录表（每日采集量统计） 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 系统管理员
 * @since 2024-12-18
 */
@RestController
@RequestMapping("/biz/scheduler/collect/day/v1/")
@Api(tags = "数据资源--ODS数据采集每日数据采集量汇总统计记录表")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ_DATASHARE})
public class BizSchedulerCollectDayController extends BaseController<BizSchedulerCollectDayManager, BizSchedulerCollectDay> {

    @PostMapping(value = "/calcSchedulerCollectDay")
    @ApiOperation("数据采集每日数据采集量汇总统计记录表（每日采集量统计）")
    public CommonResult<String> calcSchedulerCollectDay() throws Exception {
        this.baseService.calcSchedulerCollectDay();
        return new CommonResult<String>(true, "提供方每日推送量统计记录表");
    }
}
