package com.artfess.dataShare.dataResource.dw.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.model.CommonResult;
import com.artfess.dataShare.dataResource.dw.model.BizDwdCatalogsTableField;
import com.artfess.dataShare.dataResource.dw.vo.DwTableDetailVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.dataShare.dataResource.dw.manager.BizDwFieldManager;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

/**
 * 数据资源-- Dw字段信息 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author WH
 * @since 2024-11-13
 */
@RestController
@Api(tags = "数据资产--DW资源数据项字段")
@RequestMapping("/biz/dataResource/dwField/v1/")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ_DATASHARE})
public class BizDwFieldController extends BaseController<BizDwFieldManager, BizDwdCatalogsTableField> {

    @Autowired
    BizDwFieldManager fieldManager;

    @PostMapping("/importFile")
    @ApiOperation(value = "导入数据资产-DW数据项-导入物理表数据字段信息", httpMethod = "POST", notes = "导入物理表数据字段信息")
    public CommonResult<String> export(@RequestParam(value = "file", required = true) MultipartFile file, String tableId) throws Exception {
        this.fieldManager.export(file,tableId);
        return new CommonResult<String>(true, "导入数据DW字段信息成功");
    }

    @PostMapping("/importDFile")
    @ApiOperation(value = "导入数据资产-DW数据项-动态表", httpMethod = "POST", notes = "导入数据资产-DW数据项-动态表")
    public CommonResult importDFile(@RequestParam(value = "file", required = true) MultipartFile file,String catalogId) throws Exception {
        this.fieldManager.exportD(file,catalogId);
        return new CommonResult<>("导入主表成功");
    }

    @PostMapping("/saveTableField")
    @ApiOperation(value = "批量维护数据表和字段信息", httpMethod = "POST", notes = "批量维护数据表和字段信息")
    public CommonResult<String> saveTableField(@RequestBody DwTableDetailVo vo) throws Exception {
        this.fieldManager.saveTableField(vo);
        return new CommonResult<String>(true, "批量维护数据汇聚字段信息");
    }

    @PostMapping("/saveOrUpdates")
    @ApiOperation(value = "批量维护数据字段信息-单独保存字段，全度需要在每个字段里面加上tableId", httpMethod = "POST", notes = "保持数据字段信息")
    public CommonResult<String> saveTableField(@RequestBody List<BizDwdCatalogsTableField> field) throws Exception {
        this.fieldManager.saveOrUpdates(field);
        return new CommonResult<String>(true, "批量维护数据汇聚字段信息");
    }

    @PostMapping("/saveOrUpdateFields")
    @ApiOperation(value = "修改发布后的表字段信息-同时要修改实体表", httpMethod = "POST", notes = "修改发布后的表字段信息-同时要修改实体表")
    public CommonResult<String> saveOrUpdateFields(@RequestBody List<BizDwdCatalogsTableField> field) throws Exception {
        this.fieldManager.saveOrUpdateFields(field);
        return new CommonResult<String>(true, "修改成功");
    }
}
