package com.artfess.dataShare.scheduler.model;

import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

/**
 * 定时任务  --- Kettle作业 配置表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author chens
 * @since 2024-12-17
 */
@ApiModel(value="BizSchedulerKettleTask对象", description="定时任务  --- Kettle作业 配置表")
@TableName("BIZ_SCHEDULER_KETTLE_TASK")
public class BizSchedulerKettleTask extends BaseModel<BizSchedulerKettleTask> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "调度作业ID")
    @TableField("JOB_ID_")
    private String jobId;

    @ApiModelProperty(value = "调度作业名称")
    @TableField("JOB_NAME_")
    private String jobName;

    @ApiModelProperty(value = "KJB文件名称")
    @TableField("KJB_NAME_")
    private String kjbName;

    @ApiModelProperty(value = "KJB文件路径")
    @TableField("KJB_PATH_")
    private String kjbPath;

    @ApiModelProperty(value = "KTR文件名称")
    @TableField("KTR_NAME_")
    private String ktrName;

    @ApiModelProperty(value = "KTR文件路径")
    @TableField("KTR_PATH_")
    private String ktrPath;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getJobId() {
        return jobId;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public String getJobName() {
        return jobName;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public String getKjbName() {
        return kjbName;
    }

    public void setKjbName(String kjbName) {
        this.kjbName = kjbName;
    }

    public String getKjbPath() {
        return kjbPath;
    }

    public void setKjbPath(String kjbPath) {
        this.kjbPath = kjbPath;
    }

    public String getKtrName() {
        return ktrName;
    }

    public void setKtrName(String ktrName) {
        this.ktrName = ktrName;
    }

    public String getKtrPath() {
        return ktrPath;
    }

    public void setKtrPath(String ktrPath) {
        this.ktrPath = ktrPath;
    }

    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "BizSchedulerKettleTask{" +
            "id=" + id +
            ", jobId=" + jobId +
            ", jobName=" + jobName +
            ", kjbName=" + kjbName +
            ", kjbPath=" + kjbPath +
            ", ktrName=" + ktrName +
            ", ktrPath=" + ktrPath +
        "}";
    }
}
