package com.artfess.dataShare.factory;

import com.artfess.table.operator.impl.BaseTableOperator;
import com.artfess.table.operator.impl.mysql.MySQLTableOperator;
import com.artfess.table.operator.impl.oracle.OracleTableOperator;
import com.artfess.table.operator.impl.postgresql.PostgreSQLTableOperator;
import com.artfess.table.operator.impl.sqlserver.SQLServerTableOperator;

public class TableOperatorFactory {

    public static BaseTableOperator getTableOperator(String dbType){
        if ("mysql".equalsIgnoreCase(dbType)){
            return new MySQLTableOperator();
        } else if ("oracle".equalsIgnoreCase(dbType)) {
            return new OracleTableOperator();
        } else if ("postgresql".equalsIgnoreCase(dbType)) {
            return new PostgreSQLTableOperator();
        }else if ("sqlserver".equalsIgnoreCase(dbType)) {
            return new SQLServerTableOperator();
        }else {
            return null;
        }
    }
}
