package com.artfess.dataShare.dataResource.app.manager;

import com.artfess.dataShare.dataResource.app.model.BizAppCatalogsTableField;
import com.artfess.base.manager.BaseManager;
import com.artfess.dataShare.dataResource.app.vo.BizAppTableDetailVo;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

/**
 * 数据应用层--APP层数据表字段信息（字段） 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author WH
 * @since 2024-12-18
 */
public interface BizAppCatalogsTableFieldManager extends BaseManager<BizAppCatalogsTableField> {
    /**
     * 根据表导入表字段
     * @param file
     * @param tableId
     * @throws Exception
     */
    void export(MultipartFile file, String tableId) throws Exception;

    /**
     * 根据实体表Id查询字敦
     * @param tableId
     * @return
     */
    List<BizAppCatalogsTableField> queryFieldByTableId(String tableId);

    /**
     * 批量维护数据汇聚字段信息
     * @param vo
     */
    void saveTableField(BizAppTableDetailVo vo);

    /**
     * 批量维护数据字段信息
     * @param field
     */
    void saveOrUpdates(List<BizAppCatalogsTableField> field);

    /**
     * 修改发布后的表字段信息-同时要修改实体表
     * @param field
     */
    void saveOrUpdateFields(List<BizAppCatalogsTableField> field) throws Exception;
}
