package com.artfess.dataShare.dataCollect.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.time.LocalDate;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 数据汇聚数据统计表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author WH
 * @since 2024-11-18
 */
@ApiModel(value="BizClusterDataCount对象", description="数据汇聚数据统计表")
@TableName("BIZ_CLUSTER_DATA_COUNT")
public class BizClusterDataCount extends BaseModel<BizClusterDataCount> {

    private static final long serialVersionUID = 1L;

    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "单位名称")
    @TableField("COMPANY_NAME_")
    private String companyName;

    @ApiModelProperty(value = "系统名称")
    @TableField("SYS_NAME_")
    private String sysName;

    @ApiModelProperty(value = "系统编码")
    @TableField("SYS_CODE_")
    private String sysCode;

    @ApiModelProperty(value = "系统名称")
    @TableField("NAME_")
    private String name;

    @ApiModelProperty(value = "系统编码")
    @TableField("CODE_")
    private String code;

    @ApiModelProperty(value = "数据表名")
    @TableField("TABLE_NAME_")
    private String tableName;

    @ApiModelProperty(value = "数据总量")
    @TableField("TOTAL_NUM_")
    private Long totalNum;

    @ApiModelProperty(value = "当天变化量")
    @TableField("CHANGE_NUM_")
    private Long changeNum;

    @ApiModelProperty(value = "当天新增量")
    @TableField("ADD_NUM_")
    private Long addNum;

    @ApiModelProperty(value = "当天修改量")
    @TableField("UPDATE_NUM_")
    private Long updateNum;

    @ApiModelProperty(value = "当天删除量")
    @TableField("DEL_NUM_")
    private Long delNum;

    @ApiModelProperty(value = "数据变化时间")
    @TableField("COUNT_DATE_")
    private LocalDate countDate;

    @ApiModelProperty(value = "数据变化时间")
    @TableField("CREATE_TIME_")
    private LocalDate createDate;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public String getSysName() {
        return sysName;
    }

    public void setSysName(String sysName) {
        this.sysName = sysName;
    }

    public String getSysCode() {
        return sysCode;
    }

    public void setSysCode(String sysCode) {
        this.sysCode = sysCode;
    }

    public String getTableName() {
        return tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public Long getTotalNum() {
        return totalNum;
    }

    public void setTotalNum(Long totalNum) {
        this.totalNum = totalNum;
    }

    public Long getChangeNum() {
        return changeNum;
    }

    public void setChangeNum(Long changeNum) {
        this.changeNum = changeNum;
    }

    public Long getAddNum() {
        return addNum;
    }

    public void setAddNum(Long addNum) {
        this.addNum = addNum;
    }

    public Long getUpdateNum() {
        return updateNum;
    }

    public void setUpdateNum(Long updateNum) {
        this.updateNum = updateNum;
    }

    public Long getDelNum() {
        return delNum;
    }

    public void setDelNum(Long delNum) {
        this.delNum = delNum;
    }

    public LocalDate getCreateDate() {
        return createDate;
    }

    public void setCreateDate(LocalDate createDate) {
        this.createDate = createDate;
    }

    public LocalDate getCountDate() {
        return countDate;
    }

    public void setCountDate(LocalDate countDate) {
        this.countDate = countDate;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "BizClusterDataCount{" +
            "id=" + id +
            ", companyName=" + companyName +
            ", sysName=" + sysName +
            ", sysCode=" + sysCode +
            ", tableName=" + tableName +
            ", totalNum=" + totalNum +
            ", changeNum=" + changeNum +
            ", addNum=" + addNum +
            ", updateNum=" + updateNum +
            ", delNum=" + delNum +
            ", createDate=" + createDate +
        "}";
    }
}
