package com.artfess.dataShare.dataCollect.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.dataShare.dataCollect.dao.BizDatasourcesRelationDao;
import com.artfess.dataShare.dataCollect.manager.BizDatasourcesRelationManager;
import com.artfess.dataShare.dataCollect.model.BizDatasourcesRelation;
import com.artfess.dataShare.dataCollect.vo.BizDataSourceVo;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

/**
 * 数据源关联表 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author WH
 * @since 2024-11-18
 */
@Service
public class BizDatasourcesRelationManagerImpl extends BaseManagerImpl<BizDatasourcesRelationDao, BizDatasourcesRelation> implements BizDatasourcesRelationManager {

    @Resource
    BizDatasourcesRelationDao relationDao;

    public List<BizDatasourcesRelation> queryBizDataSourceByType(int type){
        QueryWrapper<BizDatasourcesRelation> queryWrapper=new QueryWrapper<>();
        queryWrapper.eq("DATASOURCES_TYPE_",type);
        List<BizDatasourcesRelation> list = this.baseMapper.selectList(queryWrapper);
        return list;
    }

    public List<BizDataSourceVo> queryList(Integer datasourcesType){
        return relationDao.queryList(datasourcesType);
    }
}
