package com.artfess.dataShare.algorithm.model;

import com.artfess.base.entity.AutoFillModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 算法推理管理----算法推理任务版本管理表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 系统管理员
 * @since 2025-01-08
 */
@ApiModel(value="BizAlgorithmVersion对象", description="算法推理管理----算法推理任务版本管理表")
public class BizAlgorithmVersion extends AutoFillModel<BizAlgorithmVersion> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID_")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "算法推理任务ID")
    @TableField("TASK_ID")
    private String taskId;

    @ApiModelProperty(value = "算法推理任务编码（唯一值）")
    @TableField("TASK_CODE_")
    private String taskCode;

    @ApiModelProperty(value = "算法推理任务名称")
    @TableField("TASK_NAME_")
    private String taskName;

    @ApiModelProperty(value = "版本发布编号（唯一值）[格式:任务编号+排序号]")
    @TableField("VERSION_CODE_")
    private String versionCode;

    @ApiModelProperty(value = "版本发布名称")
    @TableField("VERSION_NAME_")
    private String versionName;

    @ApiModelProperty(value = "版本发布时间")
    @TableField("VERSION_PUBLISH_TIME_")
    private LocalDateTime versionPublishTime;

    @ApiModelProperty(value = "版本发布人(研究员)")
    @TableField("VERSION_PUBLISH_USER_")
    private String versionPublishUser;

    @ApiModelProperty(value = "排序")
    @TableField("SN_")
    private Integer sn;

    @ApiModelProperty(value = "删除标记（1已删除，0未删除）")
    @TableField("IS_DELE_")
    @TableLogic
    private String isDele;

    @ApiModelProperty(value = "租户ID")
    @TableField("TENANT_ID_")
    private String tenantId;

    @ApiModelProperty(value = "推理类型（1：一推多 2：多推一）")
    @TableField("TYPE_")
    private Integer type;

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getTaskId() {
        return taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public String getTaskCode() {
        return taskCode;
    }

    public void setTaskCode(String taskCode) {
        this.taskCode = taskCode;
    }

    public String getTaskName() {
        return taskName;
    }

    public void setTaskName(String taskName) {
        this.taskName = taskName;
    }

    public String getVersionCode() {
        return versionCode;
    }

    public void setVersionCode(String versionCode) {
        this.versionCode = versionCode;
    }

    public String getVersionName() {
        return versionName;
    }

    public void setVersionName(String versionName) {
        this.versionName = versionName;
    }

    public LocalDateTime getVersionPublishTime() {
        return versionPublishTime;
    }

    public void setVersionPublishTime(LocalDateTime versionPublishTime) {
        this.versionPublishTime = versionPublishTime;
    }

    public String getVersionPublishUser() {
        return versionPublishUser;
    }

    public void setVersionPublishUser(String versionPublishUser) {
        this.versionPublishUser = versionPublishUser;
    }

    public Integer getSn() {
        return sn;
    }

    public void setSn(Integer sn) {
        this.sn = sn;
    }

    public String getIsDele() {
        return isDele;
    }

    public void setIsDele(String isDele) {
        this.isDele = isDele;
    }

    public String getTenantId() {
        return tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }


    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    public BizAlgorithmVersion parse(BizAlgorithmTaskinfo taskinfo){
        BizAlgorithmVersion version=new BizAlgorithmVersion();
        version.setIsDele("0");
        version.setTaskCode(taskinfo.getCode());
        version.setTaskName(taskinfo.getName());
        version.setTaskId(taskinfo.getId());
        //version.setVersionPublishTime(LocalDateTime.now());
        //IUser user= ContextUtil.getCurrentUser();
        //version.setVersionPublishUser(user.getUsername());
        return version;
    }

    @Override
    public String toString() {
        return "BizAlgorithmVersion{" +
            "id=" + id +
            ", taskId=" + taskId +
            ", taskCode=" + taskCode +
            ", taskName=" + taskName +
            ", versionCode=" + versionCode +
            ", versionName=" + versionName +
            ", versionPublishTime=" + versionPublishTime +
            ", versionPublishUser=" + versionPublishUser +
            ", sn=" + sn +
            ", isDele=" + isDele +
            ", tenantId=" + tenantId +
        "}";
    }
}
