package com.artfess.sysConfig.persistence.model;

import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.SqlCondition;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @Program: edp
 * @Date: 2021/3/2
 * @Author: ZQF
 * @Description: 任务执行器信息
 */
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "SysActuator", description = "任务执行器信息")
@TableName("portal_sys_actuator")
@Data
public class SysActuator extends BaseModel<SysActuator> {

    @ApiModelProperty(value = "主键ID")
    @TableId("ID_")
    private String id;

    @ApiModelProperty(value = "执行器名称")
    @TableField(value = "ACTUATOR_NAME_",condition= SqlCondition.LIKE)
    private String actuatorName;

    @ApiModelProperty(value = "执行器执行路径")
    @TableField("EXECUTION_PATH_")
    private String executionPath;

    @ApiModelProperty(value = "执行器IP")
    @TableField(value = "ACTUATOR_IP_",condition= SqlCondition.LIKE)
    private String actuatorIp;

    @ApiModelProperty(value = "执行器端口号")
    @TableField("ACTUATOR_PORT_")
    private String actuatorPort;

    @ApiModelProperty(value = "执行器状态")
    @TableField("ACTUATOR_STATUS_")
    private Integer actuatorStatus;

    @ApiModelProperty(value = "排序号")
    @TableField("SN_")
    private Integer sn;

    @ApiModelProperty(value = "有效标志（0：无效  1：有效）")
    @TableField("FLAG_")
    private Integer flag;

    @TableLogic
    @ApiModelProperty(value = "是否已删，1已删除，0未删除")
    @TableField("IS_DELE_")
    private String isDele = "0";

}
