package com.artfess.file.attachmentService;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;

import com.artfess.file.params.FlowUploadPropertiesStorageDTO;
import org.springframework.stereotype.Service;

import com.artfess.base.attachment.Attachment;
import com.artfess.base.attachment.AttachmentService;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.FileUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.file.model.FlowUploadProperties;
import com.artfess.file.persistence.manager.FlowUploadPropertiesManager;
import com.artfess.file.util.AppFileUtil;

@Service
public class FolderAttachmentServiceImpl implements AttachmentService{

	public FolderAttachmentServiceImpl(){

	}

	public void remove(Attachment attachment,String propertiesId) throws Exception {
		String attachPath = getAttachPath(propertiesId,attachment);
		String filePath = attachment.getFilePath();
		if(!attachment.getEntryptName()){
			filePath = filePath.replace(attachment.getId(), attachment.getFileName());
		}
		String fullPath = attachPath + File.separator + filePath;
		// 删除文件
		FileUtil.deleteFile(fullPath);
	}

	@Override
	public void upload(Attachment attachment, InputStream inputStream,String propertiesId) throws Exception {
		String filePath = attachment.getFilePath();
		String attachPath = getAttachPath(propertiesId,attachment);
		if(!attachment.getEntryptName()){
			filePath = filePath.replace(attachment.getId(), attachment.getFileName());
		}
		filePath=attachPath+File.separator+filePath;
		if(BeanUtils.isNotEmpty(inputStream)) {
			FileUtil.createFolderFile(filePath);
			FileUtil.writeFile(filePath, inputStream);
		}
		else {
			FileUtil.writeByte(filePath, attachment.getBytes());
		}
	}

	public void download(Attachment attachment, OutputStream outStream,String propertiesId)
			throws Exception {
		String filePath = attachment.getFilePath();
		String attachPath = getAttachPath(propertiesId,attachment);
		if(!attachment.getEntryptName()){
			filePath = filePath.replace(attachment.getId(), attachment.getFileName());
		}
		filePath=attachPath+File.separator+filePath;
		String fullPath = filePath.replace("/", File.separator);
		File file = new File(fullPath);
		if (file.exists()) {
			FileInputStream inputStream = null;
			try{
				inputStream = new FileInputStream(fullPath);
				byte[] b = new byte[1024];
				int i = 0;
				while ((i = inputStream.read(b)) > 0) {
					outStream.write(b, 0, i);
				}
				outStream.flush();
			}catch(Exception e){
				throw e;
			}finally{
				if (inputStream != null) {
					inputStream.close();
					inputStream = null;
				}
				if (outStream != null) {
					outStream.close();
					outStream = null;
				}
			}
		}else {
			throw new RuntimeException("该附件不存在");
		}
	}


	@Override
	public String getStoreType() {
		return "folder";
	}

	@Override
	public boolean chekckFile(Attachment attachment,String propertiesId) {
		String filePath = attachment.getFilePath();
		String attachPath = getAttachPath(propertiesId,attachment);
		if(!attachment.getEntryptName()){
			filePath = filePath.replace(attachment.getId(), attachment.getFileName());
		}
		filePath=attachPath+File.separator+filePath;
		String fullPath = filePath.replace("/", File.separator);
		File file = new File(fullPath);
		return file.exists();
	}

	/**
	 * 获取文件上传根目录
	 * @param propertiesId
	 * @return
	 */
	private String getAttachPath(String propertiesId,Attachment attachment){
		FlowUploadPropertiesStorageDTO uploadProperties = getUploadProperties(propertiesId);
		String attachPath = "";
		if(BeanUtils.isNotEmpty(uploadProperties)){
			attachPath = uploadProperties.getLocation();
			attachment.setEntryptName(uploadProperties.getEncryptName()==0?false:true);
		}else{
			attachPath = AppFileUtil.getAttachPath();
		}
		return attachPath;
	}

	/**
	 * 根据配置id获取文件上传配置
	 * @param propertiesId
	 * @return
	 */
	private FlowUploadPropertiesStorageDTO getUploadProperties(String propertiesId){
		if(StringUtil.isEmpty(propertiesId)){
			return null;
		}
		FlowUploadPropertiesManager uploadPropertiesManager = AppUtil.getBean(FlowUploadPropertiesManager.class);
		return uploadPropertiesManager.getById(propertiesId);
	}

	@Override
	public byte[] getFileBytes(Attachment sysFile) throws Exception {

		String filePath = sysFile.getFilePath();
		String fullPath = StringUtil.trimSufffix(AppFileUtil.getAttachPath(),
				File.separator)
				+ File.separator
				+ filePath.replace("/", File.separator);

		File file = new File(fullPath);
		if (file.exists()) {
			ByteArrayOutputStream outStream = new ByteArrayOutputStream();
			FileInputStream inputStream = null;
			try {
				inputStream = new FileInputStream(fullPath);
				byte[] b = new byte[1024];
				int i = 0;
				while ((i = inputStream.read(b)) > 0) {
					outStream.write(b, 0, i);
				}
				outStream.flush();
				return outStream.toByteArray();
			} catch (Exception e) {
				throw e;
			} finally {
				if (inputStream != null) {
					inputStream.close();
					inputStream = null;
				}
				if (outStream != null) {
					outStream.close();
					outStream = null;
				}
			}
		} else {
			throw new RuntimeException("该附件不存在");
		}
    }

	@Override
	public String getUrl(Attachment attachment) {
		return null;
	}

	@Override
	public String initMultiPartUpload(Attachment attachment) {
		return null;
	}

	@Override
	public String getChunkUrl(Attachment attachment, Integer partNumber, String uploadId) {
		return null;
	}

	@Override
	public boolean mergeMultipartUpload(Attachment attachment, String uploadId, int realyPartNumber) {
		return false;
	}
}
