package com.artfess.dataShare.util;

import com.artfess.table.model.Column;
import com.artfess.table.model.Table;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class TableVo implements Table {

    private String tableName;
    private String comment;
    private List<Column> columns = new ArrayList<>();
    private List<Column> primaryKey = new ArrayList<>();

    @Override
    public String getTableName() {
        return this.tableName;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    @Override
    public List<Column> getColumnList() {
        return this.columns;
    }

    @Override
    public List<Column> getPrimayKey() {
        return this.primaryKey;
    }

    @Override
    public void setTableName(String name) {
        this.tableName = name;
    }

    @Override
    public void setComment(String comment) {
        this.comment = comment;
    }

    @Override
    public void setColumnList(List<Column> columns) {
        this.columns = columns;
        this.primaryKey = columns.stream()
                .filter(entity -> entity.getIsPk())
                .collect(Collectors.toList());
    }

    @Override
    public void addColumn(Column column) {
        this.columns.add(column);
        if (column.getIsPk()){
            this.primaryKey.add(column);
        }
    }
}
