package com.artfess.dataShare.dataResource.dw.controller;


import com.alibaba.fastjson.JSON;
import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.annotation.PowerLogInfo;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.context.BaseContext;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.LogType;
import com.artfess.base.enums.OperationType;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.artfess.dataShare.dataResource.dw.manager.BizDwCatalogsManager;
import com.artfess.dataShare.dataResource.dw.model.BizDwCatalogs;
import com.artfess.sysConfig.constants.CategoryConstants;
import com.artfess.sysConfig.persistence.manager.SysTypeManager;
import com.artfess.sysConfig.persistence.model.SysCategory;
import com.artfess.sysConfig.persistence.model.SysType;
import com.artfess.uc.api.impl.util.ContextUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

/**
 * 数据资产--Dw资源目录
 * @company 阿特菲斯信息技术有限公司
 * @author wh
 * @since 2024-11-13
 */
@Slf4j
@RestController
@Api(tags = "数据资产--DW资源目录")
@RequestMapping("/biz/dataResource/dwCatalogs/v1/")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ_DATASHARE})
public class BizDwCatalogsController extends BaseController<BizDwCatalogsManager, BizDwCatalogs> {

    @Autowired
    private BaseContext baseContext;

    @Autowired
    BizDwCatalogsManager dwCatalogsManager;

    @Autowired
    private SysTypeManager sysTypeManager;

    @Override
    @PostMapping("/")
    @ApiOperation("添加实体的接口")
    public CommonResult<String> create(@ApiParam(name="model", value="实体信息") @RequestBody @Validated({AddGroup.class}) BizDwCatalogs t) {
        t.setIsDele("0");
        String id = baseService.insertTree(t);
        if(t.getSn() == null){
            t.setSn(baseService.getNextSequence(null));
            baseService.updateById(t);
        }
        if(!StringUtils.isNotBlank(id)) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return new CommonResult<String>(true, "添加成功");
        /*String parentId=t.getParentId();
        SysType sysType=new SysType();
        sysType.setId(id);
        sysType.setName(t.getName());
        //如果是根目录就放到“数据资产”的下级
        if(StringUtil.isEmpty(t.getParentId())){
            parentId="1856598104472821760";
            sysType.setParentId(parentId);
        }else {
            sysType.setParentId(t.getParentId());
        }
        sysType.setTypeGroupKey("DEF_TYPE");
        sysType.setTypeKey(t.getCode());
        //是否根节点
        int isRoot=0;

        String resultMsg = null;
        //String id = sysType.getId();
        String typeKey = sysType.getTypeKey();
        String typeGroupKey = sysType.getTypeGroupKey();
        String curUserId = ContextUtil.getCurrentUserId();
        if (StringUtil.isEmpty(id)) {
            id = null;
        }
        boolean isKeyExist = sysTypeManager.isKeyExist(id, typeGroupKey, typeKey);
        if (isKeyExist) {
            resultMsg = "输入的分类key【" + typeKey + "】已存在!";
            return new CommonResult<String>(false, resultMsg);
        } else {
            try {
                // 如果不是根节点，则需要更新分类的叶子
                if (isRoot != 1) {
                    SysType parentSysType = sysTypeManager.get(parentId);
                    if (BeanUtils.isNotEmpty(parentSysType)) {
                        parentSysType.setIsLeaf(SysCategory.IS_LEAF_N);
                        sysTypeManager.update(parentSysType);
                    }
                }

                SysType sysTypeTemp = sysTypeManager.getInitSysTypeOldId(isRoot, parentId,id);
                // 分类key不为数据字典的情况
                if (!typeGroupKey.equals(CategoryConstants.CAT_DIC.key())) {
                    sysType.setStruType(sysTypeTemp.getStruType());
                }
                // 设置是否是私有的分类 0 表示公共的分类，当前用户Id表示私有的分类
                sysType.setOwnerId("0");
                sysType.setTypeGroupKey(typeGroupKey);
                sysType.setTypeKey(typeKey);
                sysType.setPath(sysTypeTemp.getPath());
                sysType.setParentId(parentId);
                sysType.setDepth(1);
                sysType.setSn(0);
                sysType.setIsLeaf(SysCategory.IS_LEAF_Y);
                sysTypeManager.create(sysType);
                resultMsg = "添加分类成功";
                return new CommonResult<String>(true, resultMsg);

            } catch (Exception e) {
                return new CommonResult<String>(false, "更新失败");
            }
        }*/
    }

    @Override
    @PutMapping("/")
    @ApiOperation("更新实体")
    public CommonResult<String> updateById(@ApiParam(name="model", value="实体信息") @RequestBody @Validated({UpdateGroup.class}) BizDwCatalogs t) {
        BizDwCatalogs byId = baseService.getById(t.getId());
        baseService.updateTree(t, byId.getName());
        return new CommonResult<String>(true, "更新成功");
        /*SysType sysType=sysTypeManager.getById(t.getId());
        sysType.setName(t.getName());

        sysType.setTypeKey(t.getCode());

        String resultMsg = null;
        String typeKey = sysType.getTypeKey();
        String typeGroupKey = sysType.getTypeGroupKey();
        if (StringUtil.isEmpty(id)) {
            id = null;
        }
        boolean isKeyExist = sysTypeManager.isKeyExist(id, typeGroupKey, typeKey);
        if (isKeyExist) {
            resultMsg = "输入的分类key【" + typeKey + "】已存在!";
            return new CommonResult<String>(false, resultMsg);
        } else {
            try {
                sysType.setSn(0);
                //SysType oldType = sysTypeManager.get(sysType.getId());
                sysTypeManager.update(sysType);
                //jmsProducer.sendToTopic(new JmsSysTypeChangeMessage(typeGroupKey,sysType.getId(),sysType.getName(),oldType.getName(),1));
                resultMsg = "更新分类成功";
            } catch (Exception e) {
                return new CommonResult<String>(false, "更新失败");
            }
        }
        return new CommonResult<String>(true, resultMsg);*/
    }

    @Override
    @DeleteMapping("/{id}")
    @ApiOperation("根据id删除")
    public CommonResult<String> deleteById(@ApiParam(name="id", value="实体id") @PathVariable String id) {
        boolean result = baseService.removeById(id);
        if(!result) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return new CommonResult<String>();
    }

    @Override
    @DeleteMapping("/")
    @ApiOperation("根据id集合批量删除")
    public CommonResult<String> deleteByIds(@ApiParam(name="ids", value="实体集合") @RequestParam String...ids) {
        boolean result = baseService.removeByIds(Arrays.asList(ids));
        if(!result) {
            return new CommonResult<String>(false,"操作成功", null);
        }
        return new CommonResult<String>(true, "操作失败", null);
    }

    @PostMapping("/getTree")
    @ApiOperation("获取DW资源目录下拉树")
    @PowerLogInfo(logType = LogType.BIZ, operaionType = OperationType.QUERY, description = "获取DW资源目录下拉树")
    public CommonResult<String> getTree(@ApiParam(name = "model", value = "获取DW资源目录下拉树") @RequestBody BizDwCatalogs entity) {
        log.info("获取DW资源目录下拉树请求参数:{}", JSON.toJSONString(entity));
        List<BizDwCatalogs> list = baseService.getTree(entity);
        return CommonResult.success(list, null);
    }

    @RequestMapping(value = "updateSequence", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "批量修改排序号", notes = "批量修改排序号")
    public CommonResult<String> updateSequence(@ApiParam(name = "params", value = "排序参数：Key：ID，Value：排序号") @RequestBody HashMap<String, Integer> params) throws Exception {
        if(!params.isEmpty()){
            baseService.updateSequence(params);
        }
        return new CommonResult<String>(true, "操作成功", null);
    }

    // List<String> currentAndChildOrgIds = baseContext.getCurrentAndChildOrgIds();
    //        queryFilter.addFilter("CREATE_ORG_ID_", currentAndChildOrgIds ,QueryOP.IN);

    @Override
    @PostMapping(value = "/query", produces = {"application/json; charset=utf-8"})
    @ApiOperation("分页查询结果")
    public PageList<BizDwCatalogs> query(@ApiParam(name = "queryFilter", value = "分页查询信息") @RequestBody QueryFilter<BizDwCatalogs> queryFilter) {
        List<String> currentAndChildOrgIds = baseContext.getCurrentAndChildOrgIds();
        queryFilter.addFilter("create_company_id_", currentAndChildOrgIds , QueryOP.IN);
        return baseService.query(queryFilter);
    }

    @RequestMapping(value = "moveTree", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "移动目录", httpMethod = "POST", notes = "移动目录")
    public CommonResult<String> moveDictionaries(@ApiParam(name = "id", value = "要移动的节点ID") @RequestParam String id,
                                                 @ApiParam(name = "treeId", value = "目录树ID") @RequestParam String parentId) throws Exception {
        dwCatalogsManager.moveTree(id, parentId);

        return new CommonResult<>(true, "移动成功");
    }
}
