package com.artfess.dataShare.dataCollect.model;

import com.artfess.base.entity.AutoOrgFillModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 数据源关联表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author WH
 * @since 2024-11-18
 */
@ApiModel(value="BizDatasourcesRelation对象", description="数据源关联表")
@TableName("BIZ_DATASOURCES_RELATION")
public class BizDatasourcesRelation extends AutoOrgFillModel<BizDatasourcesRelation> {

    private static final long serialVersionUID = 1L;

    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "数据源别名（唯一）")
    @TableField("ALIAS_")
    private String alias;

    @ApiModelProperty(value = "数据源类型（1：汇聚交换，2：ODS，3：DW，4：共享）")
    @TableField("DATASOURCES_TYPE_")
    private Integer datasourcesType;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getAlias() {
        return alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public Integer getDatasourcesType() {
        return datasourcesType;
    }

    public void setDatasourcesType(Integer datasourcesType) {
        this.datasourcesType = datasourcesType;
    }


    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "BizDatasourcesRelation{" +
            "id=" + id +
            ", alias=" + alias +
            ", datasourcesType=" + datasourcesType +
        "}";
    }
}
