package com.artfess.dataShare.algorithm.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 算法推理管理----算法指标关系说明表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 系统管理员
 * @since 2025-01-15
 */
@ApiModel(value="BizAlgorithmRelation对象", description="算法推理管理----算法指标关系说明表")
public class BizAlgorithmRelation extends BaseModel<BizAlgorithmRelation> {

    private static final long serialVersionUID = 1L;

    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "算法推理任务ID")
    @TableField("TASK_ID_")
    private String taskId;

    @ApiModelProperty(value = "算法推理任务版本ID")
    @TableField("TASK_VERSON_ID")
    private String taskVersonId;

    @ApiModelProperty(value = "特征指标编码（参照指标库的值）")
    @TableField("CURRENT_INDEX_ID_")
    private String currentIndexId;

    @ApiModelProperty(value = "特征指标编码（参照指标库的值）")
    @TableField("CURRENT_INDEX_CODE_")
    private String currentIndexCode;

    @ApiModelProperty(value = "特征指标名称")
    @TableField("CURRENT_INDEX_NAME_")
    private String currentIndexName;

    @ApiModelProperty(value = "被关联指标编码")
    @TableField("RELATION_CODE_")
    private String relationCode;

    @ApiModelProperty(value = "被关联指标ID")
    @TableField("RELATION_INDEX_ID_")
    private String relationIndexId;

    @ApiModelProperty(value = "被关联指标名称")
    @TableField("RELATION_NAME_")
    private String relationName;

    @ApiModelProperty(value = "关联关系计算公式说明")
    @TableField("RELATION_CONTENT_")
    private String relationContent;

    public String getCurrentIndexId() {
        return currentIndexId;
    }

    public void setCurrentIndexId(String currentIndexId) {
        this.currentIndexId = currentIndexId;
    }

    public String getCurrentIndexCode() {
        return currentIndexCode;
    }

    public void setCurrentIndexCode(String currentIndexCode) {
        this.currentIndexCode = currentIndexCode;
    }

    public String getCurrentIndexName() {
        return currentIndexName;
    }

    public void setCurrentIndexName(String currentIndexName) {
        this.currentIndexName = currentIndexName;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getTaskId() {
        return taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public String getTaskVersonId() {
        return taskVersonId;
    }

    public void setTaskVersonId(String taskVersonId) {
        this.taskVersonId = taskVersonId;
    }

    public String getRelationCode() {
        return relationCode;
    }

    public void setRelationCode(String relationCode) {
        this.relationCode = relationCode;
    }

    public String getRelationName() {
        return relationName;
    }

    public void setRelationName(String relationName) {
        this.relationName = relationName;
    }

    public String getRelationContent() {
        return relationContent;
    }

    public void setRelationContent(String relationContent) {
        this.relationContent = relationContent;
    }

    public String getRelationIndexId() {
        return relationIndexId;
    }

    public void setRelationIndexId(String relationIndexId) {
        this.relationIndexId = relationIndexId;
    }

    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "BizAlgorithmRelation{" +
            "id=" + id +
            ", taskId=" + taskId +
            ", taskVersonId=" + taskVersonId +
                ", indexId=" + currentIndexId +
                ", indexCode=" + currentIndexCode +
                ", indexName=" + currentIndexName +
            ", relationCode=" + relationCode +
            ", relationName=" + relationName +
            ", relationContent=" + relationContent +
        "}";
    }
}
