package com.artfess.dataShare.algorithm.model;

import com.artfess.base.entity.BaseTreeModel;
import com.artfess.base.model.Tree;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.google.common.collect.Lists;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.antlr.runtime.tree.BaseTree;

/**
 * 算法推理管理----指标逻辑关系表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 系统管理员
 * @since 2025-01-18
 */
@ApiModel(value="BizAlgorithmReason对象", description="算法推理管理----指标逻辑关系表")
public class BizAlgorithmReason extends BaseTreeModel<BizAlgorithmReason> implements Tree {

    private static final long serialVersionUID = 1L;

    //@TableId(value = "ID_", type = IdType.ASSIGN_ID)
    //private String id;

    @ApiModelProperty(value = "算法推理任务ID")
    @TableField("TASK_ID_")
    private String taskId;

    @ApiModelProperty(value = "算法推理任务版本ID")
    @TableField("TASK_VERSON_ID")
    private String taskVersonId;

    @ApiModelProperty(value = "推理类型（1：一推多 2：多推一）")
    @TableField("TYPE_")
    private Integer type;

    @ApiModelProperty(value = "指标字段关联状态（0：未关联字段 1：已关联字段）")
    @TableField("FIELD_RELATION_STATUS_")
    private String fieldRelationStatus;

    @ApiModelProperty(value = "特征指标类型（1：结果指标 2：问题指标 3：属性指标）")
    @TableField("INDEX_TYPE_")
    private String indexType;

    /*@ApiModelProperty(value = "指标编码（参照指标库的值）")
    @TableField("CODE_")
    private String code;

    @ApiModelProperty(value = "指标标题名称")
    @TableField("NAME_")
    private String name;

    @ApiModelProperty(value = "父级目录ID")
    @TableField("PARENT_ID_")
    private String parentId;*/

    @ApiModelProperty(value = "权重比值")
    @TableField("WEIGHT_")
    private String weight;

    @ApiModelProperty(value = "当前层级")
    @TableField("LEVEL_")
    private Integer level;

   /* @ApiModelProperty(value = "ID路径")
    @TableField("FULL_ID_")
    private String fullId;

    @ApiModelProperty(value = "指标名称_全路径")
    @TableField("FULL_NAME_")
    private String fullName;

    @ApiModelProperty(value = "子节点个数")
    @TableField("HAS_CHILDREN_")
    private Integer hasChildren;*/

    @ApiModelProperty(value = "是否需要反向更新结果（0：不需要  1：是需要）")
    @TableField("UPDATE_RESULT_")
    private String updateResult;

    @ApiModelProperty(value = "排序")
    @TableField("SN_")
    private Integer sn;

    @ApiModelProperty(value = "显示背景颜色")
    @TableField("BACKGROUND_")
    private String background;

    @ApiModelProperty(value = "指标显示字体颜色")
    @TableField("FONT_COLOR_")
    private String fontColor;

    @ApiModelProperty(value = "指标显示字体大小")
    @TableField("FONT_SIZE_")
    private String fontSize;

    @ApiModelProperty(value = "指标显示字体加粗（字体粗细 bold normal）")
    @TableField("FONT_WETIGHT_")
    private String fontWetight;

    @ApiModelProperty(value = "指标显示字体斜体（字体斜体 italic norma）")
    @TableField("FONT_STYLE_")
    private String fontStyle;

    @ApiModelProperty(value = "指标图标样式")
    @TableField("INDEX_ICON_")
    private String indexIcon;

    @ApiModelProperty(value = "插入指标备注说明")
    @TableField("INDEX_MEMO_")
    private String indexMemo;

    @ApiModelProperty(value = "插入指标注释说明")
    @TableField("INDEX_ANNOTATION_")
    private String indexAnnotation;

    @ApiModelProperty(value = "插入指标的附件URL地址")
    @TableField("INDEX_URL_")
    private String indexUrl;

    @ApiModelProperty(value = "关联计算说明")
    @TableField("CONTENT_")
    private String content;

    @ApiModelProperty(value = "关联关系计算公式说明")
    @TableField("RELATION_CONTENT_")
    private String relationContent;

    public String getRelationContent() {
        return relationContent;
    }

    public void setRelationContent(String relationContent) {
        this.relationContent = relationContent;
    }

    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    @TableField(exist=false)
    protected List<Tree> children = Lists.newArrayList();

    @Override
    public String getText() {
        return name;
    }

    @Override
    public List<Tree> getChildren() {
        return this.children;
    }

    @Override
    public void setChildren(List<Tree> list) {
        this.children = list;
    }

    @Override
    public void setIsParent(String isParent) {

    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getTaskId() {
        return taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public String getTaskVersonId() {
        return taskVersonId;
    }

    public void setTaskVersonId(String taskVersonId) {
        this.taskVersonId = taskVersonId;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getFieldRelationStatus() {
        return fieldRelationStatus;
    }

    public void setFieldRelationStatus(String fieldRelationStatus) {
        this.fieldRelationStatus = fieldRelationStatus;
    }

    public String getIndexType() {
        return indexType;
    }

    public void setIndexType(String indexType) {
        this.indexType = indexType;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getParentId() {
        return parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public String getWeight() {
        return weight;
    }

    public void setWeight(String weight) {
        this.weight = weight;
    }

    public Integer getLevel() {
        return level;
    }

    public void setLevel(Integer level) {
        this.level = level;
    }

    public String getFullId() {
        return fullId;
    }

    public void setFullId(String fullId) {
        this.fullId = fullId;
    }

    public String getFullName() {
        return fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public Integer getHasChildren() {
        return hasChildren;
    }

    public void setHasChildren(Integer hasChildren) {
        this.hasChildren = hasChildren;
    }

    public String getUpdateResult() {
        return updateResult;
    }

    public void setUpdateResult(String updateResult) {
        this.updateResult = updateResult;
    }

    public Integer getSn() {
        return sn;
    }

    public void setSn(Integer sn) {
        this.sn = sn;
    }

    public String getBackground() {
        return background;
    }

    public void setBackground(String background) {
        this.background = background;
    }

    public String getFontColor() {
        return fontColor;
    }

    public void setFontColor(String fontColor) {
        this.fontColor = fontColor;
    }

    public String getFontSize() {
        return fontSize;
    }

    public void setFontSize(String fontSize) {
        this.fontSize = fontSize;
    }

    public String getFontWetight() {
        return fontWetight;
    }

    public void setFontWetight(String fontWetight) {
        this.fontWetight = fontWetight;
    }

    public String getFontStyle() {
        return fontStyle;
    }

    public void setFontStyle(String fontStyle) {
        this.fontStyle = fontStyle;
    }

    public String getIndexIcon() {
        return indexIcon;
    }

    public void setIndexIcon(String indexIcon) {
        this.indexIcon = indexIcon;
    }

    public String getIndexMemo() {
        return indexMemo;
    }

    public void setIndexMemo(String indexMemo) {
        this.indexMemo = indexMemo;
    }

    public String getIndexAnnotation() {
        return indexAnnotation;
    }

    public void setIndexAnnotation(String indexAnnotation) {
        this.indexAnnotation = indexAnnotation;
    }

    public String getIndexUrl() {
        return indexUrl;
    }

    public void setIndexUrl(String indexUrl) {
        this.indexUrl = indexUrl;
    }

    /*@ApiModelProperty(value = "算法指标关系说明表")
    @TableField(exist=false)
    protected List<BizAlgorithmRelation> relationList;

    public List<BizAlgorithmRelation> getRelationList() {
        return relationList;
    }

    public void setRelationList(List<BizAlgorithmRelation> relationList) {
        this.relationList = relationList;
    }*/

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @ApiModelProperty(value = "算法推理任务版本名称")
    @TableField(exist = false)
    private String taskVersionName;

    public String getTaskVersionName() {
        return taskVersionName;
    }

    public void setTaskVersionName(String taskVersionName) {
        this.taskVersionName = taskVersionName;
    }

    @Override
    public String toString() {
        return "BizAlgorithmReason{" +
            "id=" + id +
            ", taskId=" + taskId +
            ", taskVersonId=" + taskVersonId +
            ", type=" + type +
            ", fieldRelationStatus=" + fieldRelationStatus +
            ", indexType=" + indexType +
            ", code=" + code +
            ", name=" + name +
            ", parentId=" + parentId +
            ", weight=" + weight +
            ", level=" + level +
            ", fullId=" + fullId +
            ", fullName=" + fullName +
            ", hasChildren=" + hasChildren +
            ", updateResult=" + updateResult +
            ", sn=" + sn +
            ", background=" + background +
            ", fontColor=" + fontColor +
            ", fontSize=" + fontSize +
            ", fontWetight=" + fontWetight +
            ", fontStyle=" + fontStyle +
            ", indexIcon=" + indexIcon +
            ", indexMemo=" + indexMemo +
            ", indexAnnotation=" + indexAnnotation +
            ", indexUrl=" + indexUrl +
        "}";
    }
}
