package com.artfess.dataShare.algorithm.manager.impl;

import com.artfess.base.exception.ApplicationException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.dataShare.algorithm.dao.BizAlgorithmCatalogsIndexDao;
import com.artfess.dataShare.algorithm.manager.BizAlgorithmCatalogsIndexManager;
import com.artfess.dataShare.algorithm.model.BizAlgorithmCatalogsIndex;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.Arrays;
import java.util.List;

/**
 * 算法推理管理-----特征指标管理表 （结果指标、问题指标、属性指标） 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 系统管理员
 * @since 2025-01-08
 */
@Service
public class BizAlgorithmCatalogsIndexManagerImpl extends BaseManagerImpl<BizAlgorithmCatalogsIndexDao, BizAlgorithmCatalogsIndex> implements BizAlgorithmCatalogsIndexManager {

    //@Resource

    public void saveAlgorithmCatalogsIndex(BizAlgorithmCatalogsIndex bizAlgorithmCatalogsIndex) throws Exception {
        if(queryBySysCodeCount(bizAlgorithmCatalogsIndex.getCode(),bizAlgorithmCatalogsIndex.getId())>0){
            throw new ApplicationException("编码已经存在");
        }
        bizAlgorithmCatalogsIndex.setIsDele("0");
        if(StringUtils.isNotBlank(bizAlgorithmCatalogsIndex.getFieldName())){
            bizAlgorithmCatalogsIndex.setFieldRelationStatus("1");
        }else{
            bizAlgorithmCatalogsIndex.setFieldRelationStatus("0");
        }
        this.saveOrUpdate(bizAlgorithmCatalogsIndex);
    }

    public Integer queryBySysCodeCount(String sysCode,String id) throws Exception {
        QueryWrapper<BizAlgorithmCatalogsIndex> queryWrapper=new QueryWrapper();
        queryWrapper.eq("CODE_",sysCode);
        queryWrapper.ne(StringUtils.isNotBlank(id),"id_",id);
        return this.baseMapper.selectCount(queryWrapper);
    }

    @Override
    @Transactional
    public void updateFlag(String ids, Integer flag) {
        List<String> idsList = Arrays.asList(ids.split(","));
        UpdateWrapper<BizAlgorithmCatalogsIndex> updateWrapper = new UpdateWrapper<>();
        updateWrapper.set("ENABLE_STATUS_", flag).in("ID_", idsList);
        this.update(null, updateWrapper);
    }
}
