/* 数据汇聚交换 */
const dataCollect = [
  {
    // 交换库数据源
    path: 'dataResource/dataCollect/changeDataSource',
    name: 'changeDataSource',
    component: () => import('@/views/dataResource/dataCollect/changeDataSource/index.vue')
  },
  {
    // 资源汇聚方
    path: 'dataResource/dataCollect/dataCollectCompany',
    name: 'dataCollectCompany',
    component: () => import('@/views/dataResource/dataCollect/dataCollectCompany/index.vue')
  },
  // 数据资源项
  {
    path: 'dataResource/dataCollect/dataCollectCompany/dataSourceItem',
    name: 'dataSourceItem',
    meta: {
      activeMenu: 'dataCollectCompany'
    },
    component: () => import('@/views/dataResource/dataCollect/dataCollectCompany/dataSourceItem/index.vue')
  },
  {
    path: 'dataResource/dataCollect/dataCollectItem',
    name: 'dataCollectItem',
    component: () => import('@/views/dataResource/dataCollect/dataCollectItem/index.vue')
  },
  {
    // 汇聚历史查询
    path: 'dataResource/dataCollect/dataCollectQuery',
    name: 'dataCollectQuery',
    component: () => import('@/views/dataResource/dataCollect/dataCollectQuery/index.vue')
  }
]

/* 贴源层管理 */
const sourceLayer = [
  {
    // 贴源层数据编目
    path: 'dataResource/sourceLayer/dataODSCatalog',
    name: 'dataODSCatalog',
    component: () => import('@/views/dataResource/sourceLayer/dataODSCatalog/index.vue')
  },
  {
    // 贴源数据查询
    path: 'dataResource/sourceLayer/tyDataManageQuery',
    name: 'tyDataManageQuery',
    component: () => import('@/views/dataResource/sourceLayer/tyDataManageQuery/index.vue')
  },
  {
    // 采集任务作业
    path: 'dataResource/sourceLayer/gatherJobTask',
    name: 'gatherJobTask',
    component: () => import('@/views/dataResource/sourceLayer/gatherJobTask/index.vue')
  },
  {
    // 采集任务作业
    path: 'dataResource/sourceLayer/gatherJobTaskLog',
    name: 'gatherJobTaskLog',
    component: () => import('@/views/dataResource/sourceLayer/gatherJobTaskLog/index.vue')
  }
]

/* 数据服务管理 */
const dataServices = [
  {
    // 应用接口管理
    path: 'dataResource/dataServices/dataServiceAPI',
    name: 'dataServices',
    component: () => import('@/views/dataResource/dataServices/dataServiceAPI/index.vue')
  },
  {
    // 接口日志查询
    path: 'dataResource/dataServices/dataServiceLog',
    name: 'dataServiceLog',
    component: () => import('@/views/dataResource/dataServices/dataServiceLog/index.vue')
  }
]

/* 明细层管理*/
const dataManage = [
  // 数据资源管理 - 明细层管理 - 资产明细编目
  {
    path: 'dataResource/dataManage/dataDWCatalog',
    name: 'dataDWCatalog',
    component: () => import('@/views/dataResource/dataManage/dataDWCatalog/index.vue')
  },
  // 数据资源管理 - 明细层管理 - 明细数据管理
  {
    path: 'dataResource/dataManage/taskActuators',
    name: 'taskActuators',
    component: () => import('@/views/dataResource/dataManage/taskActuators/index.vue')
  },
  // 数据资源管理 - 明细层管理 - 数据治理任务
  {
    path: 'dataResource/dataManage/dataGovernance',
    name: 'dataGovernance',
    component: () => import('@/views/dataResource/dataManage/dataGovernance/index.vue')
  },
  // 数据资源管理 - 明细层管理 - 数据治理日志
  {
    path: 'dataResource/dataManage/dataTaskLog',
    name: 'dataTaskLog',
    component: () => import('@/views/dataResource/dataManage/dataTaskLog/index.vue')
  },
  // 数据资源管理 - 明细层管理 - 多维字典管理
  {
    path: 'dataResource/dataManage/dataDimension',
    name: 'dataDimension',
    component: () => import('@/views/dataResource/dataManage/dataDimension/index.vue')
  }
]

/* 应用层管理*/
const appLayer = [
  // 数据资源管理 - 应用层管理 - 资产明细编目
  {
    path: 'dataResource/appLayer/appLayerCatalogue',
    name: 'appLayerCatalogue',
    component: () => import('@/views/dataResource/appLayer/appLayerCatalogue/index.vue')
  },
  // 数据资源管理 - 应用层管理 - 明细数据管理
  {
    path: 'dataResource/appLayer/appLayerQuery',
    name: 'appLayerQuery',
    component: () => import('@/views/dataResource/appLayer/appLayerQuery/index.vue')
  },
  // 数据资源管理 - 应用层管理 - 数据治理任务
  {
    path: 'dataResource/appLayer/appLayerTasks',
    name: 'appLayerTasks',
    component: () => import('@/views/dataResource/appLayer/appLayerTasks/index.vue')
  },

  // 数据资源管理 - 应用层管理 - 数据治理日志
  {
    path: 'dataResource/appLayer/appLayerLog',
    name: 'appLayerLog',
    component: () => import('@/views/dataResource/appLayer/appLayerLog/index.vue')
  }
]

/* 数据共享管理*/
const dataShare = [
  {
    // 需求方
    path: 'dataResource/dataShare/shareDataCall',
    name: 'shareDataCall',
    component: () => import('@/views/dataResource/dataShare/shareDataCall/index.vue')
  },
  {
    // 共享资源编目
    path: 'dataResource/dataShare/shareDataCatalog',
    name: 'shareDataCatalog',
    component: () => import('@/views/dataResource/dataShare/shareDataCatalog/index.vue')
  },
  // {
  //   // 共享资源按钮 编辑字段->跳转页面
  //   path: 'editField',
  //   name: 'editField',
  //   component: () => import('@/views/dataResource/zDemo/editField/index.vue'),
  // },
  {
    // 共享资源按钮 接口信息->跳转页面
    path: 'dataResource/dataShare/shareDataCatalog/apiInterface',
    name: 'shareDataCatalogApiInterface',
    meta: {
      activeMenu: 'shareDataCatalog'
    },
    component: () => import('@/views/dataResource/dataShare/shareDataCatalog/apiInterface/index.vue')
  },
  {
    // 共享资源按钮 文件共享->跳转页面
    path: 'dataResource/dataShare/offlineFile',
    name: 'offlineFile',
    meta: {
      activeMenu: 'shareDataCatalog'
    },
    component: () => import('@/views/dataResource/dataShare/shareDataCatalog/offlineFile/index.vue')
  },
  {
    // 接口共享管理
    path: 'dataResource/dataShare/shareApi/apiInterface',
    name: 'apiInterface',
    component: () => import('@/views/dataResource/dataShare/shareApi/apiInterface/index.vue')
  },
  {
    // 库表共享
    path: 'dataResource/dataShare/shareTable',
    name: 'shareTable',
    component: () => import('@/views/dataResource/dataShare/shareTable/index.vue')
  },
  {
    // 离线文件共享
    path: 'dataResource/dataShare/shareFile',
    name: 'shareFile',
    component: () => import('@/views/dataResource/dataShare/shareFile/index.vue')
  },
  {
    // 共享资源按钮 文件共享->跳转页面
    path: 'dataResource/dataShare',
    name: 'offlineCheckFile',
    meta: {
      activeMenu: 'shareFile'
    },
    component: () => import('@/views/dataResource/zDemo/offlineFile/index.vue')
  },
  {
    // API接口共享
    path: 'dataResource/dataShare/shareApi',
    name: 'shareApi',
    component: () => import('@/views/dataResource/dataShare/shareApi/index.vue')
  },
  {
    // 共享资源按钮 接口信息->跳转页面
    path: 'dataResource/dataShare/apiInterface',
    name: 'apiInterfaceShareApi',
    meta: {
      activeMenu: 'shareApi'
    },
    component: () => import('@/views/dataResource/dataShare/shareApi/apiInterface/index.vue')
  },
  {
    // 数据调用日志
    path: 'dataResource/dataShare/shareLog',
    name: 'shareLog',
    component: () => import('@/views/dataResource/dataShare/shareLog/index.vue')
  },
  {
    // 数据调用日志
    path: 'dataResource/dataShare/dataSharePush',
    name: 'dataSharePush',
    component: () => import('@/views/dataResource/dataShare/dataSharePush/index.vue')
  },
  {
    // 共享库数据源
    path: 'dataResource/dataShare/shareDataSource',
    name: 'shareDataSource',
    component: () => import('@/views/dataResource/dataShare/shareDataSource/index.vue')
  },
  {
    // 共享任务作业
    path: 'dataResource/dataShare/dataShareJob',
    name: 'dataShareJob',
    component: () => import('@/views/dataResource/dataShare/dataShareJob/index.vue')
  },
  {
    // 共享任务作业
    path: 'dataResource/dataShare/dataShareJobLog',
    name: 'dataShareJobLog',
    component: () => import('@/views/dataResource/dataShare/dataShareJobLog/index.vue')
  }
]

const arithmeticManage = [
  {
    // 算法指标管理
    path: 'dataResource/arithmeticManage/arithmeticInfo',
    name: 'arithmeticInfo',
    component: () => import('@/views/dataResource/arithmeticManage/arithmeticInfo/index.vue')
  },
  {
    // 算法指标新增
    path: 'dataResource/arithmeticManage/algorithmAddition',
    name: 'algorithmAddition',
    meta: {
      activeMenu: 'arithmeticInfo'
    },
    component: () => import('@/views/dataResource/arithmeticManage/arithmeticInfo/Provider/AddEditPage.vue')
  },
  {
    // 共享库数据源
    path: 'dataResource/arithmeticManage/arithmeticTask',
    name: 'arithmeticTask',
    component: () => import('@/views/dataResource/arithmeticManage/arithmeticTask/index.vue')
  }
]

export default [
  /* 数据汇聚交换 */
  ...dataCollect,
  /* 贴源层管理 */
  ...sourceLayer,
  /* 数据服务管理 */
  ...dataServices,
  /* 明细层管理*/
  ...dataManage,
  /* 应用层管理*/
  ...appLayer,
  /* 数据共享管理*/
  ...dataShare,
  /* 特征算法管理*/
  ...arithmeticManage,
  // 示例部分
  {
    // tree加table
    path: 'treeTable',
    name: 'treeTable',
    component: () => import('@/views/dataResource/zDemo/treeTable/index.vue')
  },
  {
    // 临时测试文件
    path: 'tyDataManageQuery',
    name: 'tyDataManageQuery',
    component: () => import('@/views/dataResource/zDemo/tyDataManageQuery/index.vue')
  }
]
