export const TableMixin = {
    data() {
        return {
            tableMaxHeight: 600,
            showMore: false,
        }
    },
    mounted() {
        this.calcTableHeight();
        this.$root.$on("resize", () => {
            this.calcTableHeight(500);
        });
    },
    methods: {
        calcTableHeight(delay) {
            // 动态计算表格的高度，自适应当前容器
            setTimeout(() => {
                if (!this.$refs.contentPanel) {
                    return;
                }
                const contentPanelHeight = this.$refs.contentPanel.clientHeight;
                const btnPanelHeight = this.$refs.btnPanel.clientHeight || 0;
                const paginationPanelHeight = this.$refs.paginationPanel ? 32 : 0
                // (this.$refs.paginationPanel &&
                //     this.$refs.paginationPanel.clientHeight) ||
                // 0;
                this.tableMaxHeight =
                    contentPanelHeight -
                    btnPanelHeight -
                    paginationPanelHeight - 50;
            }, delay || 0);
        },
        handleDbClick(row, column, event) {
            this.handleUpdate(row)
        },
        commonPageClick() {
            if (this.showMore) {
                this.showMore = false
            }
        }

    }
}