# codeEditor 使用文档

###### 说明: 一个简易版的代码编辑器，支持语法高亮

## 参数配置

| 参数        | 类型    | 必填 | 说明                                           |
| ----------- | ------- | ---- | ---------------------------------------------- |
| language    | string  |      | 表示当前编写代码的类型 javascript/html/css/sql |
| placeholder | string  |      | placeholder                                    |
| lineNumbers | Boolean |      | 是否显示行号                                   |
| fullScreen  | Boolean |      | 是否显示全屏按钮                               |
| zIndex      | string  |      | 全屏以后的 z-index                             |

## 使用示例

```vue
<template>
  <div>
    <code-editor language="javascript" v-model="editorValue" :fullScreen="true" style="min-height: 100px" />
    {{ editorValue }}
  </div>
</template>

<script>
import codeEditor from '@/components/codeEditor';
export default {
  components: { codeEditor },
  data() {
    return {
      editorValue: '',
    };
  },
};
</script>
```
