import req from '@/request.js';

const bpmModel = window.context.bpmModel;
const bpmRunTime = window.context.bpmRunTime;
const portal = window.context.portal;

export default {
  // 获取汇聚方分页列表数据
  downLoadFile(tableId) {
    return new Promise((resolve, reject) => {
      req.post(`${bpmModel}/biz/dataCollect/clusterTable/v1/downloadMainTempFile/${tableId}`, null, 'blob').then(
        (response) => {
          resolve(response.data);
        },
        (error) => {
          reject(error);
        },
      );
    });
  },
  // 查询导入数据
  getTableDatas(data) {
    return new Promise((resolve, reject) => {
      req.post(`${portal}/biz/dataCollect/clusterTable/v1/queryTableData`, data).then(
        // req.post(`${portal}/biz/dataResource/odsTable/v1/queryTableData`, data).then(
        (response) => {
          resolve(response.data);
        },
        (error) => {
          reject(error);
        },
      );
    });
  },
};
