import req from '@/request.js';

const bpmModel = window.context.bpmModel;
const portal = window.context.portal;
const headersUrlencoded = {
  Accept: 'application/json;charset=utf-8',
  'Content-type': 'multipart/form-data',
};
const company = {
  // 获取汇聚方分页列表数据
  getList(data) {
    return new Promise((resolve, reject) => {
      req.post(`${bpmModel}/biz/dataCollect/clusterInfo/v1/query`, data).then(
        response => {
          resolve(response.data);
        },
        error => {
          reject(error);
        },
      );
    });
  },
  // 新增汇聚方
  addCompany(data) {
    return new Promise((resolve, reject) => {
      req.post(`${portal}/biz/dataCollect/clusterInfo/v1/saveClusterInfo`, data).then(
        response => {
          if (response.data?.state) {
            resolve(response.data);
          } else {
            reject(response);
          }
        },
        error => {
          reject(error);
        },
      );
    });
  },
  // 验证账户
  checkAccount(data) {
    return new Promise((resolve, reject) => {
      req.post(`${portal}/biz/dataCollect/clusterInfo/v1/checkUserExists`, data).then(
        response => {
          if (response.data?.state) {
            resolve(response.data);
          } else {
            reject(response);
          }
        },
        error => {
          reject(error);
        },
      );
    });
  },
  // 查询详情
  getCompanyDetail(id) {
    return new Promise((resolve, reject) => {
      req.post(`${portal}/biz/dataCollect/clusterInfo/v1/queryClusterInfo/${id}`).then(
        response => {
          resolve(response.data);
        },
        error => {
          reject(error);
        },
      );
    });
  },
  delCompany(id) {
    return new Promise((resolve, reject) => {
      req.remove(`${portal}/biz/dataCollect/clusterInfo/v1/${id}`).then(
        response => {
          resolve(response.data);
        },
        error => {
          reject(error);
        },
      );
    });
  },
};

const dataSource = {
  // 获取汇聚方数据源分页列表数据
  getDataSourceList(data) {
    return new Promise((resolve, reject) => {
      req.post(`${bpmModel}/biz/dataCollect/clusterTable/v1/query`, data).then(
        response => {
          resolve(response.data);
        },
        error => {
          reject(error);
        },
      );
    });
  },
  addSource(data) {
    return new Promise((resolve, reject) => {
      req.post(`${bpmModel}/biz/dataCollect/clusterTable/v1/`, data).then(
        response => {
          if (response.data?.state) {
            resolve(response.data);
          } else {
            reject(response);
          }
        },
        error => {
          reject(error);
        },
      );
    });
  },
  updateSource(data) {
    return new Promise((resolve, reject) => {
      req.put(`${bpmModel}/biz/dataCollect/clusterTable/v1/`, data).then(
        response => {
          if (response.data?.state) {
            resolve(response.data);
          } else {
            reject(response);
          }
        },
        error => {
          reject(error);
        },
      );
    });
  },
  delSource(id) {
    return new Promise((resolve, reject) => {
      req.post(`${portal}/biz/dataCollect/clusterTable/v1/removeTable?tableId=${id}`).then(
        response => {
          resolve(response.data);
        },
        error => {
          reject(error);
        },
      );
    });
  },
  getSourceDetail(id) {
    return new Promise((resolve, reject) => {
      req.get(`${bpmModel}/biz/dataCollect/clusterTable/v1/${id}`).then(
        response => {
          resolve(response.data);
        },
        error => {
          reject(error);
        },
      );
    });
  },
  getFieldsList(id) {
    return new Promise((resolve, reject) => {
      req.post(`${bpmModel}/biz/dataCollect/clusterTable/v1/queryTableVo/${id}`).then(
        response => {
          resolve(response.data);
        },
        error => {
          reject(error);
        },
      );
    });
  },
  saveFields(data) {
    return new Promise((resolve, reject) => {
      req.post(`${bpmModel}/biz/dataCollect/clusterTable/v1/saveTableVo`, data).then(
        response => {
          if (response.data?.state) {
            resolve(response.data);
          } else {
            reject(response);
          }
        },
        error => {
          reject(error);
        },
      );
    });
  },
  // 发布后批量保存
  saveOrUpdateFields(data) {
    return new Promise((resolve, reject) => {
      req.post(`${bpmModel}/biz/dataCollect/clusterField/v1/saveOrUpdateFields`, data).then(
        response => {
          if (response.data?.state) {
            resolve(response.data);
          } else {
            reject(response);
          }
        },
        error => {
          reject(error);
        },
      );
    });
  },
  publishTable(tableId) {
    return new Promise((resolve, reject) => {
      req.post(`${bpmModel}/biz/dataCollect/clusterTable/v1/Deploy/${tableId}`).then(
        response => {
          if (response.data?.state) {
            resolve(response.data);
          } else {
            reject(response);
          }
        },
        error => {
          reject(error);
        },
      );
    });
  },
  delFields(id) {
    return new Promise((resolve, reject) => {
      req.remove(`${bpmModel}/biz/dataCollect/clusterField/v1/${id}`).then(
        response => {
          if (response.data?.state) {
            resolve(response.data);
          } else {
            reject(response);
          }
        },
        error => {
          reject(error);
        },
      );
    });
  },
  // 查询触发器
  queryTrigger(tableId) {
    return new Promise((resolve, reject) => {
      req.post(`${bpmModel}/biz/dataCollect/clusterTable/v1/queryTableInfo/${tableId}`).then(
        response => {
          resolve(response.data);
        },
        error => {
          reject(error);
        },
      );
    });
  },

  // 新增验证表英文名
  checkSurfaceName(data) {
    return new Promise((resolve, reject) => {
      req.post(`${portal}/biz/dataCollect/clusterTable/v1/checkTableExists?tableNameEn=${data.tableNameEn}&clusterId=${data.clusterId}&type=${data.type}`).then(
        response => {
          if (response.data?.state) {
            resolve(response.data);
          } else {
            reject(response);
          }
        },
        error => {
          reject(error);
        },
      );
    });
  },
  // 发布验证表英文名
  checkSurfaceCh(data) {
    return new Promise((resolve, reject) => {
      req
        .post(`${portal}/biz/dataCollect/clusterTable/v1/checkPhysicsTableExists?tableNameEn=${data.tableNameEn}&clusterId=${data.clusterId}&type=${data.type}`)
        .then(
          response => {
            if (response.data?.state) {
              resolve(response.data);
            } else {
              reject(response);
            }
          },
          error => {
            reject(error);
          },
        );
    });
  },
  addSurfaceSource(data) {
    return new Promise((resolve, reject) => {
      req.post(`${bpmModel}/biz/dataCollect/clusterTable/v1/copyTable`, data).then(
        response => {
          if (response.data?.state) {
            resolve(response.data);
          } else {
            reject(response);
          }
        },
        error => {
          reject(error);
        },
      );
    });
  },

  gainTableSql(tableId) {
    return new Promise((resolve, reject) => {
      req.post(`${bpmModel}/biz/dataCollect/clusterTable/v1/queryTableSql/${tableId}`).then(
        response => {
          if (response.data?.state) {
            resolve(response.data);
          } else {
            reject(response);
          }
        },
        error => {
          reject(error);
        },
      );
    });
  },

  // 未有表发布
  unpublishedTable(data) {
    const param = {
      url: `${bpmModel}/biz/dataCollect/clusterTable/v1/deployDotHaveTable`,
      data,
      method: 'post',
      headers: headersUrlencoded,
    };
    return new Promise((resolve, reject) => {
      req.request(param).then(
        response => {
          if (response.data?.state) {
            resolve(response.data);
          } else {
            reject(response);
          }
        },
        error => {
          reject(error);
        },
      );
    });
  },
  // 已有表发布
  existingTablePublishing(data) {
    const param = {
      url: `${bpmModel}/biz/dataCollect/clusterTable/v1/deployHaveTable`,
      data,
      method: 'post',
      headers: headersUrlencoded,
    };
    return new Promise((resolve, reject) => {
      req.request(param).then(
        response => {
          if (response.data?.state) {
            resolve(response.data);
          } else {
            reject(response);
          }
        },
        error => {
          reject(error);
        },
      );
    });
  },

  // 已有表发布
  // existingTablePublishing(data) {
  //   return new Promise((resolve, reject) => {
  //     req.post(`${bpmModel}/biz/dataCollect/clusterTable/v1/deployHaveTable?tableId=${data.tableId}&createTrigger=${data.createTrigger}`).then(
  //       response => {
  //         if (response.data?.state) {
  //           resolve(response.data);
  //         } else {
  //           reject(response);
  //         }
  //       },
  //       error => {
  //         reject(error);
  //       },
  //     );
  //   });
  // },

  // 手动创建触发器
  createdTriggerChange(tableId) {
    return new Promise((resolve, reject) => {
      req.post(`${bpmModel}/biz/dataCollect/clusterTable/v1/createdTrigger/tableId=${tableId}`, data).then(
        response => {
          if (response.data?.state) {
            resolve(response.data);
          } else {
            reject(response);
          }
        },
        error => {
          reject(error);
        },
      );
    });
  },
};

export default {
  ...company,
  ...dataSource,
};
