import req from '@/request.js';

const portal = window.context.portal;

const headersUrlencoded = {
    'Content-type': 'application/x-www-form-urlencoded'
}
export default {
    // 算法任务查询
    getInferenceList(data) {
        return new Promise((resolve, reject) => {
            req.post(`${portal}/biz/algorithm/taskInfo/v1/query`, data)
                .then((res) => resolve(res?.data || {}))
                .catch((err) => reject(err));
        });
    },
    // 算法任务新增
    addInference(data) {
        return new Promise((resolve, reject) => {
            req.post(`${portal}/biz/algorithm/taskInfo/v1/`, data)
                .then((res) => resolve(res?.data || {}))
                .catch((err) => reject(err));
        });
    },
    // 算法任务编辑
    editInference(data) {
        return new Promise((resolve, reject) => {
            req.put(`${portal}/biz/algorithm/taskInfo/v1/`, data)
                .then((res) => resolve(res?.data || {}))
                .catch((err) => reject(err));
        });
    },
    // 算法任务删除
    deleteInference(ids) {
        return new Promise((resolve, reject) => {
            req.remove(`${portal}/biz/algorithm/taskInfo/v1/?${ids}`)
                .then((res) => resolve(res?.data || {}))
                .catch((err) => reject(err));
        });
    },
    // 查询任务版本
    getInferenceVersion(data) {
        return new Promise((resolve, reject) => {
            req.post(`${portal}/biz/algorithm/version/v1/query`, data)
                .then((res) => resolve(res?.data || {}))
                .catch((err) => reject(err));
        });
    },
    // 发布算法任务
    publishInferenceTask(data) {
        let param = {
            url: `${portal}/biz/algorithm/taskInfo/v1/deploy`,
            data,
            method: "post",
            headers: headersUrlencoded
        }
        return new Promise((resolve, reject) => {
            req.request(param)
                .then((res) => resolve(res.data || {}))
                .catch((err) => reject(err));
        })
    },
    // 修改任务状态
    updateInferenceStatus(data) {
        let param = {
            url: `${portal}/biz/algorithm/taskInfo/v1/updateDeployedStatus`,
            data,
            method: "post",
            headers: headersUrlencoded
        }
        return new Promise((resolve, reject) => {
            req.request(param)
                .then((res) => resolve(res.data || {}))
                .catch((err) => reject(err));
        })
    },
    // 查询脑图信息
    getBrainMapInfo(data) {
        return new Promise((resolve, reject) => {
            req.postFormData(`${portal}/biz/algorithm/reason/v1/queryReason`, data)
                .then((res) => resolve(res?.data || []))
                .catch((err) => reject(err));
        });
    },
    // 获取一个新的版本号
    getNewVersion(data) {
        return new Promise((resolve, reject) => {
            req.post(`${portal}/biz/algorithm/version/v1/getNewVersionCode`, data)
                .then((res) => resolve(res?.data || {}))
                .catch((err) => reject(err));
        });
    },
    // 保存脑图信息
    saveBrainMapInfo(data) {
        return new Promise((resolve, reject) => {
            req.post(`${portal}/biz/algorithm/version/v1/saveTaskVersion`, data)
                .then((res) => resolve(res?.data || {}))
                .catch((err) => reject(err));
        });
    },
    // 算法指标列表
    getTargetList(data) {
        return new Promise((resolve, reject) => {
            req.post(`${portal}/biz/algorithm/catalogsIndex/v1/query`, data)
                .then((res) => resolve(res?.data || {}))
                .catch((err) => reject(err));
        });
    },
};
