import req from '@/request.js';

const portal = window.context.portal;

const headersUrlencoded = {
    'Content-type': 'application/x-www-form-urlencoded'
}

export default {
    // 获取区域
    getAreaTree() {
        return new Promise((resolve, reject) => {
            req.post(`${portal}/sys/sysAreas/v1/querySysAreas`)
                .then((res) => resolve(res.data || []))
                .catch((err) => reject(err));
        });
    },
    // 获取区域
    queryAreaByParentId(data) {
        let param = {
            url: `${portal}/sys/sysAreas/v1/queryByParentId`,
            data,
            method: "post",
            headers: headersUrlencoded
        }
        return new Promise((resolve, reject) => {
            req.request(param)
                .then((res) => resolve(res.data || []))
                .catch((err) => reject(err));
        })
    },
    getAreaList(data) {
        return new Promise((resolve, reject) => {
            req.post(`${portal}/sys/sysAreas/v1/slicedQuerySysAreas`, data)
                .then((res) => resolve(res.data || []))
                .catch((err) => reject(err));
        });
    },
    saveArea(data) {
        return new Promise((resolve, reject) => {
            req.post(`${portal}/sys/sysAreas/v1/saveSysAreas`, data)
                .then((res) => resolve(res.data || []))
                .catch((err) => reject(err));
        });
    },
    deleteArea(id) {
        let data = {
            url: portal + `/sys/sysAreas/v1/deleteBatch`,
            data: id,
            method: "post",
            headers: headersUrlencoded
        }
        return new Promise((resolve, reject) => {
            req.request(data)
                .then((res) => resolve(res.data || {}))
                .catch((err) => reject(err));
        });
    },
    updateSequence(data) {
        return new Promise((resolve, reject) => {
            req.post(`${portal}/sys/sysAreas/v1/updateSequence`, data)
                .then((res) => resolve(res.data || {}))
                .catch((err) => reject(err));
        })
    }
};
