# artfess-upload 

上传组件

## 参数

|属性|类型|默认值|说明|
|:---|:---|:---|:---|
|url|String|系统分片接口地址| 上传接口地址|
|chunkSize|Number|10| 分片大小，单位M | 
|filesData|Object| - | 文件列表数据 ，key为文件名| 
|isMultiple|Boolean|false| 是否允许多文件上传 |
|drag|Boolean|false| 是否开启拖拽上传 |
|directory|Boolean|false| 是否开启文件夹上传 |
|disabled|Boolean|false| 是否禁用 |
|limit|Number| - | 允许上传的文件数量 |
|onExceedMessage|String| - | 文件数量超出limit限制时提示语 |
|accept|String| - | 允许上传的文件类型，例：'.jpg' |
|notAcceptMessage|String| - | 存在不允许上传文件类型的提示语 |
|listHeight|String| - | 文件列表的高度 |
|excessData|Object| - | 附带的上传的业务参数 |
|beforeUpload|Function| - | 上传前的钩子，可用于处理文件类型和大小过滤，返回true继续上传，返回false停止上传 |

## 事件

|事件名|描述|返回参数|
|:---|:---|:---|
|preview|上传成功后点击文件触发，可以用预览|filesData, file|
|success|上传成功触发|filesData, successFile|
|remove|上传成功后点击删除文件触发|filesData, removeFile|
|error|上传失败触发|filesData, errorFile|

## slot

|名称|描述|
|:---|:---|
|tip|文件上传提示信息，文件大小、类型、数量等限制条件|
| - |匿名插槽将替换上传按钮或显示在拖拽区域|

## filesData 文件列表数据结构

filesData:{

    key:{  // 组件内部文件唯一标识  ，建议设置为负数，防止和内部产生的 uid 冲突
        id: '', // 已上传文件id，可用户预览
        uid: uid, // 同key
        name: 'xx.png', // 文件名
        folder: '/上传文件夹/xx.png', // 文件目录，如为单文件，此值为空
        status: 'success', // 状态 pending success pause error
        chunk: [], // 分片数据，无需设置
        size: '', // 文件大小，无需设置
        percentage: -1, // 上传进度，无需设置
        requestList: [], // 请求的列表用于暂停操作，无需设置，
    }

}

```
<template>
    <upload
        drag
        directory
        listHeight="102px"
        class="test-upload"
        :limit='5'
        :onExceedMessage="onExceedMessage"
        :notAcceptMessage="notAcceptMessage"
        :beforeUpload="beforeUpload"
        :excessData="excessData"
        :filesData="filesData"
        @success="success"
        @preview="preview"
        @remove="remove"
        >
          <div slot="tip">上传提示</div>
    </upload> 
</template>
<script>
export default {
    data() {
        return {
            excessData: {
                bizId: 2222222,
            },
            filesData: {
                '-123456': {
                    id: 123456,
                    name: 'image.png'
                },
            },
            notAcceptMessage: '上传文件类型不匹配',
            onExceedMessage: '超出数量限制',
        }
    },
    methods: {
        beforeUpload(filesData) {
            console.log(filesData, 'beforeUpload')
            return true
        },
        success(filesData, file) {
            console.log(filesData, file, 'success')
        },
        preview(filesData, file) {
            console.log(filesData, file, 'preview')
        },
        remove(filesData, removefile) {
            console.log(filesData, removefile, 'removeFile')
        },
        error(filesData, errorfile) {
            console.log(filesData, errorfile, 'error')
        },
    }
}
</script>
<style>
.test-upload {
    width: 400px;
}
</style>

```
