package com.artfess.base.handler;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Date;

import javax.annotation.Resource;

import com.artfess.base.context.BaseContext;
import org.apache.commons.lang.StringUtils;
import org.apache.ibatis.reflection.MetaObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import com.baomidou.mybatisplus.core.handlers.MetaObjectHandler;


/**
 * 字段自动填充处理器
 *
 * @company 广州宏天软件股份有限公司
 * @author heyifan
 * @email heyf@jee-soft.cn
 * @date 2020年4月8日
 */
@Component
public class AutoFillMetaObjectHandler implements MetaObjectHandler{
	private final Logger logger = LoggerFactory.getLogger(getClass());

	@Resource
	BaseContext baseContext;

	@Override
	public void insertFill(MetaObject metaObject) {
		logger.info("start insert fill ....");
		String createBy = baseContext.getCurrentUserId();
		String createOrgId = baseContext.getCurrentOrgId();
		if(StringUtils.isBlank(createBy)){
			createBy = "admin";
		}
		if(StringUtils.isBlank(createOrgId)){
			createOrgId = "1432534718389293056";
		}
		this.strictInsertFill(metaObject, "createBy", String.class, createBy);
		this.strictInsertFill(metaObject, "createOrgId", String.class, createOrgId);
		this.strictInsertFill(metaObject, "createTime", LocalDateTime.class, (LocalDateTime)getSetterTypeOfLocal(metaObject, "createTime"));
	}

	@Override
	public void updateFill(MetaObject metaObject) {
		logger.info("start update fill ....");
		String updateBy = baseContext.getCurrentUserId();
		if(StringUtils.isBlank(updateBy)){
			updateBy = "admin";
		}
		this.strictUpdateFill(metaObject, "updateBy", String.class, updateBy);
		this.setFieldValByName("updateTime", getSetterTypeOfLocal(metaObject, "updateTime"), metaObject);
	}

	/**
	 *  通过属性元信息获取指定属性的当前值
	 *  <p>主要解决不同的日期类型的字段当前值</p>
	 * @param metaObject
	 * @param propertyName
	 * @return
	 */
	private Object getSetterTypeOfLocal(MetaObject metaObject, String propertyName){
		Class<?> targetType = metaObject.getSetterType(propertyName);
		Object obj = null;
		if(LocalDateTime.class.equals(targetType)) {
			obj = LocalDateTime.now();
		}
		else if(LocalDate.class.equals(targetType)) {
			obj = LocalDate.now();
		}
		else if(Date.class.equals(targetType)) {
			obj = new Date();
		}
		return obj;
	}
}
