package com.artfess.base.util;

import com.artfess.base.exception.BaseException;
import lombok.extern.slf4j.Slf4j;

import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;

/**
 * 对接泛微des加密工具
 */
@Slf4j
public class DES {
    private String pwd = null;

    public DES(String paramString) {
        this.pwd = paramString;
    }

    /**
     * 加密
     *
     * @param paramString
     * @return
     */
    public String encode(String paramString) {
        byte[] arrayOfByte1 = null;
        try {
            if (this.pwd == null)
                this.pwd = "ecology9";

            DESKeySpec localDESKeySpec = new DESKeySpec(this.pwd.getBytes());
            SecretKeyFactory localSecretKeyFactory = SecretKeyFactory.getInstance("DES");
            SecretKey localSecretKey = localSecretKeyFactory.generateSecret(localDESKeySpec);

            Cipher localCipher = Cipher.getInstance("DES/ECB/PKCS5Padding");
            localCipher.init(1, localSecretKey);
            byte[] arrayOfByte2 = paramString.getBytes();
            arrayOfByte1 = localCipher.doFinal(arrayOfByte2);
        } catch (Exception localException) {
            log.error("加密异常！", localException);
            return null;
        }

        return parseByte2HexStr(arrayOfByte1);
    }

    /**
     * 解密
     *
     * @param paramString
     * @return
     */
    public String decode(String paramString) {
        byte[] arrayOfByte1 = null;
        byte[] arrayOfByte2 = parseHexStr2Byte(paramString);
        try {
            if (this.pwd == null)
                this.pwd = "ecology9";

            DESKeySpec localDESKeySpec = new DESKeySpec(this.pwd.getBytes());
            SecretKeyFactory localSecretKeyFactory = SecretKeyFactory.getInstance("DES");
            SecretKey localSecretKey = localSecretKeyFactory.generateSecret(localDESKeySpec);

            Cipher localCipher = Cipher.getInstance("DES/ECB/PKCS5Padding");
            localCipher.init(Cipher.DECRYPT_MODE, localSecretKey);
            arrayOfByte1 = localCipher.doFinal(arrayOfByte2);
        } catch (Exception localException) {
            log.error("解密异常！", localException);
            throw new BaseException("账号解密异常！");
        }

        return new String(arrayOfByte1);
    }

    public boolean setPwd(String paramString) {
        this.pwd = paramString;
        return true;
    }

    public boolean setIv(String paramString) {
        return true;
    }

    private String parseByte2HexStr(byte[] paramArrayOfByte) {
        StringBuffer localStringBuffer = new StringBuffer();
        for (int i = 0; i < paramArrayOfByte.length; ++i) {
            String str = Integer.toHexString(paramArrayOfByte[i] & 0xFF);
            if (str.length() == 1) {
                str = '0' + str;
            }

            localStringBuffer.append(str.toUpperCase());
        }
        return localStringBuffer.toString();
    }

    private byte[] parseHexStr2Byte(String paramString) {
        if (paramString.length() < 1) {
            return null;
        }

        byte[] arrayOfByte = new byte[paramString.length() / 2];
        for (int i = 0; i < paramString.length() / 2; ++i) {
            int j = Integer.parseInt(paramString.substring(i * 2, i * 2 + 1), 16);
            int k = Integer.parseInt(paramString.substring(i * 2 + 1, i * 2 + 2), 16);
            arrayOfByte[i] = (byte) (j * 16 + k);
        }
        return arrayOfByte;
    }

    public static void main(String[] args) {
        DES des = new DES(null);
        String enc = des.encode("admin");

        System.out.println("加密后：" + enc);
        System.out.println("加密前：" + des.decode(enc));
    }
}
