package com.artfess.base.enums;

import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

/**
 * 科目类型
 */
@Getter
public enum SubjectSpeciesEnum {

    BS("BS", "资产类"),

    PL("PL", "利润类"),

    CF("CF", "现金类"),

    HR("HR", "人资类"),

    SA("SA", "国资委上报类"),

    ;

    SubjectSpeciesEnum(String type, String desc){
        this.type = type;
        this.desc = desc;
    }

    private String type;

    private String desc;

    public static String getType(String desc){
        if(StringUtils.isEmpty(desc)){
            return null;
        }
        SubjectSpeciesEnum[] values = values();
        for (SubjectSpeciesEnum state : values) {
            if (state.getDesc().equals(desc)) {
                return state.getType();
            }
        }
        return null;
    }
}
