package com.artfess.base.enums;

import com.artfess.base.util.StringUtil;
import lombok.Getter;

/**
 * 运营数据分析指标
 */
@Getter
public enum OperationTargetTypeEnum {
    // 运营数据分析指标
    ndsj(1,"年度实际VS预算分析","The annual actual VS budget analysis", "3,4"),
    ndkhsy(2,"年度客户实际VS预算分析","Annual Customer Actual VS Budget Analysis", "3,4"),
    ndkh(3,"年度客户占比饼状图","Annual customer proportion","3"),
    ndcpsy(4,"年度产品实际VS预算分析","Annual Product Actual VS Budget Analysis","3,4"),
    ndcp(5,"年度产品占比饼状图","Annual Product proportion","3"),
    dysj(6,"当月实际VS预算分析","Analysis of actual VS budget this month","1,2"),
    ndlb(7,"年度类别占比饼状图","Annual type proportion","3"),
    ndgs(8,"年度公司占比饼状图","Annual Company proportion","3"),

    scqysj(9,"年销售额累计","Production enterprise actual VS budget analysis", "3"),
    fscqysj(10,"生命周期销售额累计","Non-production enterprise actual VS budget analysis","3"),
    zzlfx(11,"客户年销售额分析","Growth analysis", "3"),
    jtwclfx(12,"客户生命周期销售额分析","Group level analysis of completion","3"),
    zqywclfx(13,"区域年销售额分析","The enterprise completion analysis rankings", "3"),
    zbfx(14,"区域生命周期销售额分析","Ratio analysis", "3"),
    zqydysj(15,"当前平均EBITDA率分析","Enterprise actual VS group average ranking that month", "7"),
    ndlbsy(16,"年度类别实际VS预算分析","Annual Type Actual VS Budget Analysis", "3,4"),
    ndgssy(17,"年度公司实际VS预算分析","Annual Company Actual VS Budget Analysis","3,4"),
    ;

    OperationTargetTypeEnum(Integer type, String targetName, String targetNameEn, String staLat){
        this.type = type;
        this.targetName = targetName;
        this.targetNameEn = targetNameEn;
        this.staLat = staLat;
    }

    private String targetName;

    private String targetNameEn;

    private Integer type;


    private String staLat;


    public static OperationTargetTypeEnum getTarget(String type){
        if(StringUtil.isEmpty(type)){
            return null;
        }
        OperationTargetTypeEnum[] values = values();
        for (OperationTargetTypeEnum state : values) {
            if (state.getType().equals(Integer.parseInt(type))) {
                return state;
            }
        }
        return null;
    }
}
