package com.artfess.base.enums;

import com.artfess.base.util.StringUtil;
import lombok.Getter;

import java.util.Arrays;
import java.util.List;

/**
 * 计算公式
 */
@Getter
public enum KpiTargetTypeEnum {
    // 运行板块指标
    //d.tr_exfi_act_,
    hr_acr_act_quantity_(1, "hrAcrActQuantity", "事故件数", "Act", "件", ""),
    tr_exfi_act_(2, "trExfiAct", "转换率", "TR", "%", ""),
    oee24_ex_epdm_act_(3, "oee24ExEpdmAct", "设备利用率", "OEE", "%", ""),
    crj_exfi_act_(4, "crjExfiAct", "客户拒收", "PPM", "件", ""),
    cc_exfi_act_(5, "ccExfiAct", "客户抱怨", "CC-CPM", "次", ""),
    qr_ex_epdm_act_(6, "qr_ex_epdm_act_", "非计划停机率", "Unplanned outage rate", "%", ""),
    hr_et_rate_bud_(7, "hrEtRateBud", "员工效率", "Employee productivity", "%", ""),

    // 销售板块指标
    oem_sale_(10, "oemSale", "OEM销售数据对比", "oem sale", "千欧", "3,4"),
    new_project_income_(11, "newProjectIncome", "新项目收入贡献数据对比", "new project income", "千欧", "3,4"),
    reduction_data_(12, "reductionData", "年降数据对比", "reduction data", "百万欧", "3,4"),
    new_order_data_(13, "newOrderData", "新订单数据", "new order data", "百万欧", "3"),
    cip(14, "cip", "持续改进数据对比", "cip", "千欧", "3,4"),
    company_cip(15, "companyCip", "持续改进数据对比-分公司", "company cip", "千欧", "3,4"),
    ;

    KpiTargetTypeEnum(Integer type, String targetId, String targetName, String targetNameEn, String targetUnit, String staLat) {
        this.type = type;
        this.targetId = targetId;
        this.targetName = targetName;
        this.targetNameEn = targetNameEn;
        this.targetUnit = targetUnit;
        this.staLat = staLat;
    }

    private String targetName;

    private String targetNameEn;

    private String targetUnit;

    private String targetId;

    private Integer type;

    private String staLat;


    public static KpiTargetTypeEnum getTarget(Integer type) {
        if (null == type) {
            return null;
        }
        KpiTargetTypeEnum[] values = values();
        for (KpiTargetTypeEnum state : values) {
            if (state.getType().equals(type)) {
                return state;
            }
        }
        return null;
    }

    public static KpiTargetTypeEnum findByTargetId(String targetId) {
        if (!StringUtil.isNotEmpty(targetId)) {
            return null;
        }
        KpiTargetTypeEnum[] values = values();
        for (KpiTargetTypeEnum state : values) {
            if (state.getTargetId().equals(targetId)) {
                return state;
            }
        }
        return null;
    }

    public static List<KpiTargetTypeEnum> salesTargetList() {
        List<KpiTargetTypeEnum> targets = Arrays.asList(KpiTargetTypeEnum.oem_sale_,
                KpiTargetTypeEnum.new_project_income_,
                KpiTargetTypeEnum.reduction_data_,
                KpiTargetTypeEnum.cip,
                KpiTargetTypeEnum.new_order_data_,
                KpiTargetTypeEnum.company_cip
        );
        return targets;
    }
}
