/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cqlt.controller;

import com.alibaba.fastjson.JSONObject;
import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.artfess.cqlt.manager.QfFinanceSasacCompanyDManager;
import com.artfess.cqlt.manager.QfFinanceSasacCompanyMManager;
import com.artfess.cqlt.model.QfFinanceSasacCompanyD;
import com.artfess.cqlt.model.QfFinanceSasacCompanyM;
import com.artfess.i18n.util.I18nUtil;
import com.artfess.uc.api.impl.util.ContextUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u8d22\u52a1--\u56fd\u8d44\u59d4\u5b50\u4f01\u4e1a\u5b63\u5ea6\u586b\u62a5\u4e3b\u8868"})
@RequestMapping(value={"/qf/financeSasac/company/"})
@ApiGroup(group={"group_biz"})
public class QfFinanceSasacCompanyMController
extends BaseController<QfFinanceSasacCompanyMManager, QfFinanceSasacCompanyM> {
    private static final Logger log = LoggerFactory.getLogger(QfFinanceSasacCompanyMController.class);
    @Autowired
    private QfFinanceSasacCompanyDManager financeSasacCompanyDManager;

    @PostMapping(value={"/"})
    @ApiOperation(value="\u6dfb\u52a0\u5b9e\u4f53\u7684\u63a5\u53e3")
    public CommonResult<String> create(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody @Validated(value={AddGroup.class}) QfFinanceSasacCompanyM t) {
        t.setFillUser(ContextUtil.getCurrentUserId());
        t.setFillDate(LocalDate.now());
        boolean result = ((QfFinanceSasacCompanyMManager)this.baseService).insertInfo(t);
        if (!result) {
            return new CommonResult(false, I18nUtil.getMessage((String)"option.fail", (Locale)LocaleContextHolder.getLocale()), null);
        }
        return new CommonResult(true, I18nUtil.getMessage((String)"option.success", (Locale)LocaleContextHolder.getLocale()), (Object)t.getId());
    }

    @PutMapping(value={"/"})
    @ApiOperation(value="\u66f4\u65b0\u5b9e\u4f53")
    public CommonResult<String> updateById(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody @Validated(value={UpdateGroup.class}) QfFinanceSasacCompanyM t) {
        boolean result = ((QfFinanceSasacCompanyMManager)this.baseService).updateInfo(t);
        if (!result) {
            return new CommonResult(false, I18nUtil.getMessage((String)"option.fail", (Locale)LocaleContextHolder.getLocale()), null);
        }
        return new CommonResult(true, I18nUtil.getMessage((String)"option.success", (Locale)LocaleContextHolder.getLocale()), null);
    }

    @PutMapping(value={"/updateStatus"})
    @ApiOperation(value="\u751f\u6548")
    public CommonResult<String> updateStatus(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody QfFinanceSasacCompanyM t) {
        boolean result = ((QfFinanceSasacCompanyMManager)this.baseService).updateStatus(t);
        if (!result) {
            return new CommonResult(false, I18nUtil.getMessage((String)"option.fail", (Locale)LocaleContextHolder.getLocale()), null);
        }
        return new CommonResult(true, I18nUtil.getMessage((String)"option.success", (Locale)LocaleContextHolder.getLocale()), null);
    }

    @DeleteMapping(value={"/{id}"})
    @ApiOperation(value="\u6839\u636eid\u5220\u9664")
    public CommonResult<String> deleteById(@ApiParam(name="id", value="\u5b9e\u4f53id") @PathVariable String id) {
        boolean result = ((QfFinanceSasacCompanyMManager)this.baseService).removeById((Serializable)((Object)id));
        if (!result) {
            return new CommonResult(false, I18nUtil.getMessage((String)"delete.fail", (Locale)LocaleContextHolder.getLocale()), null);
        }
        return new CommonResult(true, I18nUtil.getMessage((String)"option.success", (Locale)LocaleContextHolder.getLocale()), null);
    }

    @DeleteMapping(value={"/"})
    @ApiOperation(value="\u6839\u636eid\u96c6\u5408\u6279\u91cf\u5220\u9664")
    public CommonResult<String> deleteByIds(String ... ids) {
        boolean result = ((QfFinanceSasacCompanyMManager)this.baseService).removeByIds(Arrays.asList(ids));
        if (!result) {
            return new CommonResult(false, I18nUtil.getMessage((String)"delete.fail", (Locale)LocaleContextHolder.getLocale()), null);
        }
        return new CommonResult(true, I18nUtil.getMessage((String)"option.success", (Locale)LocaleContextHolder.getLocale()), null);
    }

    @ApiOperation(value="\u4e0a\u62a5\u56fd\u8d44\u59d4\u62a5\u8868\u8f6c\u6362")
    @GetMapping(value={"/conversion"})
    public CommonResult<String> conversion(@RequestParam(value="mainId", required=false) String mainId) {
        try {
            boolean result = ((QfFinanceSasacCompanyMManager)this.baseService).conversion(mainId);
            if (!result) {
                throw new IllegalArgumentException(I18nUtil.getMessage((String)"option.fail", (Locale)LocaleContextHolder.getLocale()));
            }
            return new CommonResult();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalArgumentException(I18nUtil.getMessage((String)"option.fail", (Locale)LocaleContextHolder.getLocale()) + "," + e.getMessage());
        }
    }

    @ApiOperation(value="\u62a5\u8868\u5bfc\u51fa")
    @PostMapping(value={"/export"})
    public void export(HttpServletRequest request, HttpServletResponse response, @ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<QfFinanceSasacCompanyD> queryFilter) throws Exception {
        PageList page = this.financeSasacCompanyDManager.query(queryFilter);
        this.financeSasacCompanyDManager.export(request, response, page.getRows(), "\u5883\u5916\u5b50\u4f01\u4e1a\u57fa\u672c\u60c5\u51b5");
    }

    @PostMapping(value={"/detailQuery"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u8be6\u60c5\u6570\u636e")
    public CommonResult detailQuery(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<QfFinanceSasacCompanyD> queryFilter) {
        PageList pageList = this.financeSasacCompanyDManager.query(queryFilter);
        List<JSONObject> list = ((QfFinanceSasacCompanyMManager)this.baseService).detailQuery(pageList.getRows());
        return CommonResult.success(list, null);
    }
}

