/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cqlt.manager.impl;

import com.artfess.base.enums.OperationTargetTypeEnum;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.cqlt.dao.QfOperationReductionsDDao;
import com.artfess.cqlt.dao.QfOperationReductionsMDao;
import com.artfess.cqlt.manager.QfOperationReductionsDManager;
import com.artfess.cqlt.model.QfOperationReductionsD;
import com.artfess.cqlt.model.QfOperationReductionsM;
import com.artfess.cqlt.model.SysSubjectTarget;
import com.artfess.cqlt.utils.FinancialTimeUtils;
import com.artfess.cqlt.vo.OpDateReqVo;
import com.artfess.cqlt.vo.OpReportReqVo;
import com.artfess.cqlt.vo.OpReportRespVo;
import com.artfess.cqlt.vo.OpTargetRespVo;
import com.artfess.i18n.util.I18nUtil;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.annotation.Resource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class QfOperationReductionsDManagerImpl
extends BaseManagerImpl<QfOperationReductionsDDao, QfOperationReductionsD>
implements QfOperationReductionsDManager {
    @Resource
    private QfOperationReductionsMDao operationReductionsMDao;
    private FinancialTimeUtils financialTimeUtils = new FinancialTimeUtils();

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean batchUpdate(QfOperationReductionsM t) {
        Assert.hasText((String)t.getId(), (String)I18nUtil.getMessage((String)"QfOperationKpiM.reportId", (Locale)LocaleContextHolder.getLocale()));
        QfOperationReductionsM QfOperationReductionsM2 = (QfOperationReductionsM)((Object)this.operationReductionsMDao.selectById((Serializable)((Object)t.getId())));
        Assert.notNull((Object)((Object)QfOperationReductionsM2), (String)I18nUtil.getMessage((String)"filldata.notExist", (Locale)LocaleContextHolder.getLocale()));
        Assert.isTrue((!"1".equals(QfOperationReductionsM2.getStatus()) ? 1 : 0) != 0, (String)I18nUtil.getMessage((String)"data_operate", (Locale)LocaleContextHolder.getLocale()));
        t.getList().forEach(detail -> detail.setMainId(t.getId()));
        boolean b = this.saveOrUpdateBatch(t.getList());
        return b;
    }

    @Override
    public List<OpReportRespVo> yearData(OpReportReqVo t) {
        return ((QfOperationReductionsDDao)this.baseMapper).yearData(t);
    }

    @Override
    public List<OpTargetRespVo> dataAnalysis(OpReportReqVo t, SysSubjectTarget target) {
        List<String> typeList = Arrays.asList(target.getType().split(","));
        ArrayList newTypeList = Lists.newArrayList();
        for (int i = 0; i < typeList.size(); ++i) {
            if (i <= 0) continue;
            newTypeList.add(typeList.get(i));
        }
        ArrayList resultList = Lists.newArrayList();
        newTypeList.forEach(type -> {
            OperationTargetTypeEnum targetTypeEnum = OperationTargetTypeEnum.getTarget((String)type);
            if (null == targetTypeEnum) {
                return;
            }
            OpDateReqVo dateReqVo = this.financialTimeUtils.processOpDateReqVo(t, (String)type);
            this.financialTimeUtils.processOpDateQuery(t, dateReqVo);
            switch (targetTypeEnum) {
                case ndsj: {
                    t.setYear(null);
                    this.yearAnalysis(target, t, resultList, targetTypeEnum);
                    break;
                }
                case ndkhsy: {
                    this.yearCustomerAnalysis(target, t, resultList, targetTypeEnum);
                    break;
                }
                case ndkh: {
                    this.yearCustomerProportion(target, t, resultList, targetTypeEnum);
                    break;
                }
                case dysj: {
                    this.monthAnalysis(target, t, resultList, targetTypeEnum);
                    break;
                }
            }
        });
        return resultList;
    }

    private void monthAnalysis(SysSubjectTarget target, OpReportReqVo t, List<OpTargetRespVo> resultList, OperationTargetTypeEnum targetTypeEnum) {
        OpTargetRespVo resultFa = this.getOpTargetRespVo(target, targetTypeEnum);
        List<OpReportRespVo> opReportRespVos = ((QfOperationReductionsDDao)this.baseMapper).monthAnalysis(t);
        opReportRespVos.forEach(resp -> resp.setYear(t.getYear()));
        resultFa.setResultData(opReportRespVos);
        resultList.add(resultFa);
    }

    private void yearCustomerProportion(SysSubjectTarget target, OpReportReqVo t, List<OpTargetRespVo> resultList, OperationTargetTypeEnum targetTypeEnum) {
        OpTargetRespVo resultFa = this.getOpTargetRespVo(target, targetTypeEnum);
        List<OpReportRespVo> opReportRespVos = ((QfOperationReductionsDDao)this.baseMapper).yearCustomerData(t);
        BigDecimal totalActual = opReportRespVos.stream().map(OpReportRespVo::getActual).reduce(BigDecimal.ZERO, BigDecimal::add);
        opReportRespVos.stream().forEach(resp -> {
            BigDecimal actual = BigDecimal.ZERO;
            if (null != resp.getActual() && 0.0 != resp.getActual().doubleValue()) {
                actual = resp.getActual().divide(totalActual, 4, 4).multiply(new BigDecimal(100));
            }
            resp.setActual(actual);
            resp.setBudget(null);
        });
        resultFa.setResultData(opReportRespVos);
        resultList.add(resultFa);
    }

    private void yearCustomerAnalysis(SysSubjectTarget target, OpReportReqVo t, List<OpTargetRespVo> resultList, OperationTargetTypeEnum targetTypeEnum) {
        OpTargetRespVo resultFa = this.getOpTargetRespVo(target, targetTypeEnum);
        List<OpReportRespVo> opReportRespVos = ((QfOperationReductionsDDao)this.baseMapper).yearData(t);
        resultFa.setResultData(opReportRespVos);
        resultList.add(resultFa);
    }

    private void yearAnalysis(SysSubjectTarget target, OpReportReqVo t, List<OpTargetRespVo> resultList, OperationTargetTypeEnum targetTypeEnum) {
        OpTargetRespVo resultFa = this.getOpTargetRespVo(target, targetTypeEnum);
        List<OpReportRespVo> opReportRespVos = ((QfOperationReductionsDDao)this.baseMapper).yearData(t);
        resultFa.setResultData(opReportRespVos);
        resultList.add(resultFa);
    }

    private OpTargetRespVo getOpTargetRespVo(SysSubjectTarget target, OperationTargetTypeEnum targetTypeEnum) {
        String type = targetTypeEnum.getType().toString();
        OpTargetRespVo resultFa = new OpTargetRespVo();
        resultFa.setTargetId(target.getId());
        resultFa.setTargetName(targetTypeEnum.getTargetName());
        resultFa.setTargetNameEn(targetTypeEnum.getTargetNameEn());
        resultFa.setTargetUnit(target.getUnit());
        resultFa.setType(type);
        resultFa.setSn(targetTypeEnum.getType());
        resultFa.setStaLat(targetTypeEnum.getStaLat());
        return resultFa;
    }
}

