/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.portal;

import com.alibaba.druid.spring.boot.autoconfigure.DruidDataSourceAutoConfigure;
import com.artfess.base.util.StringUtil;
import com.artfess.i18n.util.I18nUtil;
import javax.servlet.MultipartConfigElement;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.web.servlet.MultipartConfigFactory;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.unit.DataSize;
import org.springframework.util.unit.DataUnit;

@SpringBootApplication(exclude={DruidDataSourceAutoConfigure.class})
@Configuration
@MapperScan(basePackages={"com.artfess.**.dao"})
@ComponentScan(value={"com.artfess.*"})
@EnableFeignClients(basePackages={"com.artfess.*"})
public class Application {
    @Value(value="${spring.servlet.multipart.maxFileSize:'1024MB'}")
    private String maxFileSize;
    @Value(value="${spring.servlet.multipart.maxRequestSize:'1024MB'}")
    private String maxRequestSize;

    public static void main(String[] args) {
        SpringApplication.run(Application.class, (String[])args);
        I18nUtil.initMessage();
    }

    @Bean
    public MultipartConfigElement multipartConfigElement() {
        MultipartConfigFactory factory = new MultipartConfigFactory();
        factory.setMaxFileSize(StringUtil.isEmpty((String)this.maxFileSize) ? DataSize.of((long)10L, (DataUnit)DataUnit.MEGABYTES) : DataSize.parse((CharSequence)this.maxFileSize));
        factory.setMaxRequestSize(StringUtil.isEmpty((String)this.maxRequestSize) ? DataSize.of((long)100L, (DataUnit)DataUnit.MEGABYTES) : DataSize.parse((CharSequence)this.maxRequestSize));
        return factory.createMultipartConfig();
    }
}

