package com.artfess.dataAccess.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.dataAccess.manager.DataAccessDefinedManager;
import com.artfess.dataAccess.model.DataAccessDefined;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;

/**
 * 数据权限定义 前端控制器
 *
 * @author llj
 * @since 2021-04-01
 */
@RestController
@Api(tags="数据权限定义")
@ApiGroup(group= {ApiGroupConsts.GROUP_UC})
@RequestMapping(value="/uc/DataAccessDefined/v1/")
public class DataAccessDefinedController extends BaseController<com.artfess.dataAccess.manager.DataAccessDefinedManager, DataAccessDefined> {
    @Resource
    DataAccessDefinedManager DataAccessDefinedManager;

    @GetMapping("queryListDataAccessDefined")
    @ApiOperation(value="根据接口id查询权限列表", httpMethod = "GET", notes = "根据接口id查询权限列表")
    public List<DataAccessDefined> queryListDataAccessDefined(@ApiParam(name="interfaceId",value="接口id",required = true)@RequestParam String interfaceId )throws Exception{
        List<DataAccessDefined> DataAccessDefineds = DataAccessDefinedManager.queryListDataAccessDefined(interfaceId);
        return DataAccessDefineds;
    }


    @PostMapping(value="saveDataAccessDefined")
    @ApiOperation(value = "新增、更新权限定义", httpMethod = "POST", notes = "新增、更新权限定义")
    public CommonResult<String> saveDataAccessDefined(@ApiParam(name="DataAccessDefined",value="权限定义对象", required = true)@RequestBody DataAccessDefined DataAccessDefined) throws Exception{
        String msg = DataAccessDefinedManager.saveDataAccessDefined(DataAccessDefined);
        return new CommonResult<String>(msg);
    }

    @DeleteMapping(value="deleteDataAccessDefinedByIds")
    @ApiOperation(value = "批量删除权限定义", httpMethod = "DELETE", notes = "批量删除权限定义")
    public CommonResult<String> deleteDataAccessDefinedByIds(@ApiParam(name="ids",value="权限定义id集合", required = true)@RequestParam List<String> ids) throws Exception{
        DataAccessDefinedManager.deleteDataAccessDefinedByIds(ids);
        return new CommonResult<String>(true, "批量删除成功");
    }

    @GetMapping("loadDataAccessDefined")
    @ApiOperation(value="根据id查询权限列表", httpMethod = "GET", notes = "根据id查询权限列表")
    public DataAccessDefined loadDataAccessDefined(@ApiParam(name="id",value="id",required = true)@RequestParam String id )throws Exception{
        DataAccessDefined DataAccessDefined = DataAccessDefinedManager.loadDataAccessDefined(id);
        return DataAccessDefined;
    }
}
