package com.artfess.portal.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.sysConfig.persistence.manager.SysActuatorManager;
import com.artfess.sysConfig.persistence.model.SysActuator;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.HashMap;
import java.util.List;

/**
 * @Program: edp
 * @Date: 2021/3/3
 * @Author: ZQF
 * @Description: 任务执行器信息
 */
@RestController
@RequestMapping("/sys/sysActuator/v1")
@Api(tags = "任务执行器信息")
@ApiGroup(group = {ApiGroupConsts.GROUP_SYSTEM})
public class SysActuatorController extends BaseController<SysActuatorManager, SysActuator> {

    @Resource
    SysActuatorManager sysActuatorManager;

    @PostMapping("slicedQueryActuator")
    @ApiOperation(value = "执行器分页查询", httpMethod = "POST", notes = "执行器分页查询")
    public PageList<SysActuator> slicedQueryActuator(@ApiParam(name = "queryFilter", value = "通用查询对象") @RequestBody QueryFilter<SysActuator> queryFilter) throws Exception {
        return sysActuatorManager.query(queryFilter);
    }

    @RequestMapping(value = "queryActuator", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "不分页查询执行器", httpMethod = "POST", notes = "不分页查询执行器")
    public List<SysActuator> queryActuator(@ApiParam(name = "sysActuator", value = "通用查询对象") @RequestBody SysActuator sysActuator) throws Exception {
        return sysActuatorManager.queryActuator(sysActuator);
    }

    @RequestMapping(value = "saveSysActuator", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "保存执行器信息", httpMethod = "POST", notes = "保存执行器信息")
    public CommonResult<String> saveSysActuator(@ApiParam(name = "sysActuator", value = "执行器对象") @RequestBody SysActuator sysActuator) throws Exception {
        String msg = sysActuatorManager.saveSysActuator(sysActuator);
        return new CommonResult<>(true, msg);
    }

//    @RequestMapping(value = "updateSequence", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
//    @ApiOperation(value = "批量修改排序号", httpMethod = "POST", notes = "批量修改排序号")
//    public CommonResult<String> updateSequence(@ApiParam(name = "params", value = "排序参数：Key：ID，Value：排序号") @RequestBody HashMap<String, Object> params) throws Exception {
//        String msg = sysActuatorManager.updateSequence(params);
//        return new CommonResult<>(true, msg);
//    }

    @RequestMapping(value = "updateFlag", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "批量修改启用禁用状态", httpMethod = "POST", notes = "批量修改启用禁用状态")
    public CommonResult<String> updateFlag(@ApiParam(name = "ids", value = "Id集合，以,隔开") @RequestParam String ids,
                                           @ApiParam(name = "flag", value = "有效标志（0：无效  1：有效）") @RequestParam Integer flag) throws Exception {
        sysActuatorManager.updateFlag(ids, flag);
        return new CommonResult<>(true, "状态修改成功");
    }

    @RequestMapping(value = "deleteBatch", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "批量删除", httpMethod = "POST", notes = "批量删除")
    public CommonResult<String> deleteBatch(@ApiParam(name = "ids", value = "Id集合，以,隔开") @RequestParam String ids) throws Exception {
        sysActuatorManager.deleteBatch(ids);
        return new CommonResult<>(true, "删除成功");
    }

}
