## 侧边栏弹窗组件

+ `ht-sidebar-dialog`组件
- 基于elementUI 中的el-dialog组件扩展 文档可参考[elementUI 2.13.0](https://element.eleme.cn/#/zh-CN/component/dialog)
- 支持el-dialog 所有属性，事件和 slot 

```html
<ht-sidebar-dialog
      :width="dialogWidthPrecent"
      title="侧边弹窗例子-添加角色"
      :visible.sync="dialogVisible"
      :before-close="handleClose"
    >
</ht-sidebar-dialog>
```


+ 侧边栏弹窗 table 布局
```html
<ht-sidebar-dialog
      :width="dialogWidthPrecent"
      title="侧边弹窗例子-添加用户"
      :visible.sync="dialogVisible3"
      :before-close="handleClose3"
    >
      <form data-vv-scope="editUserForm">
        <table class="form-table" cellspacing="0" cellpadding="0" border="0">
          <tbody>
            <tr>
              <th width="120px" class="is-required">用户名称:</th>
              <td>
                <ht-input v-model="user.fullname" autocomplete="off" :validate="{required:true}"></ht-input>
              </td>
              <th width="120px" class="is-required">用户账号:</th>
              <td>
                <ht-input v-model="user.account" autocomplete="off" :validate="{required:true}"></ht-input>
              </td>
            </tr>
            <tr>
              <th width="120px">用户性别:</th>
              <td>
                <ht-radio
                  v-model="user.sex"
                  :options="[{key:'1',value:'男士'},{key:'0',value:'女士'}]"
                />
              </td>
              <th width="120px">手机号码:</th>
              <td>
                <ht-input v-model="user.mobile" autocomplete="off" :validate="{mobile:true}"></ht-input>
              </td>
            </tr>
          </tbody>
        </table>
      </form>
      <div slot="footer" class="dialog-footer">
        <el-button @click="dialogCancle">取 消</el-button>
        <el-button type="primary" @click="dialogSave">保 存</el-button>
        <ht-save-button
          scope-name="editUserForm"
          :is-submit="isSubmit"
          @before-save-data="beforeSaveData"
        >HtSaveButton</ht-save-button>
      </div>
      <div slot="title">
        <span style="color:red;">我是slot标题，会覆盖title中的设置</span>
      </div>
</ht-sidebar-dialog>
```

+ 侧边栏弹窗 <el-form>布局
```html
<ht-sidebar-dialog
      :width="dialogWidthPrecent"
      title="侧边弹窗例子-添加角色"
      :visible.sync="dialogVisible"
      :before-close="handleClose"
    >
      <el-form
        data-vv-scope="editRoleForm"
        :model="form"
        :label-position="formSetting.labelPosition"
        size="mini"
        :inline="formSetting.inline"
      >
        <ht-form-item label="角色名称" label-width="80px">
          <ht-input v-model="form.roleName" autocomplete="off" :validate="{required:true}"></ht-input>
        </ht-form-item>
        <ht-form-item label="角色别名" label-width="80px">
          <ht-input v-model="form.roleCode" autocomplete="off" validate="required"></ht-input>
        </ht-form-item>
        <ht-form-item label="状态" label-width="80px">
          <ht-select
            v-model="form.status"
            :options="[{'alias': 0, 'value':'禁用'},{'alias': 1, 'value':'启用'}]"
            :props="{key:'alias',value:'value'}"
            :validate="{'required':true}"
          />
        </ht-form-item>
        <ht-form-item label="角名称" label-width="80px">
          <ht-input v-model="form.roleName" autocomplete="off" :validate="{required:true}"></ht-input>
        </ht-form-item>
        <ht-form-item label="角色别名" label-width="80px">
          <ht-input v-model="form.roleCode" autocomplete="off" validate="required"></ht-input>
        </ht-form-item>
        <ht-form-item label="性别" label-width="80px">
          <ht-radio
            v-model="form.status"
            :options="[{'key': 0, 'value':'禁用'},{'key': 1, 'value':'启用'}]"
            :validate="{'required':true}"
          />
        </ht-form-item>
        <ht-form-item label="角色名称" label-width="80px">
          <ht-input v-model="form.roleName" autocomplete="off" :validate="{required:true}"></ht-input>
        </ht-form-item>
        <ht-form-item label="角色别名" label-width="80px">
          <ht-input v-model="form.roleCode" autocomplete="off" validate="required"></ht-input>
        </ht-form-item>
        <ht-form-item label="角色状态" label-width="80px">
          <ht-select
            v-model="form.status"
            :options="[{'key': 0, 'value':'禁用'},{'key': 1, 'value':'启用'}]"
            :validate="{'required':true}"
          />
        </ht-form-item>
        <ht-form-item label="角色名称" label-width="80px">
          <ht-input v-model="form.roleName" autocomplete="off" :validate="{required:true}"></ht-input>
        </ht-form-item>
        <ht-form-item label="角色别名" label-width="80px">
          <ht-input v-model="form.roleCode" autocomplete="off" validate="required"></ht-input>
        </ht-form-item>
        <ht-form-item label="角色状态" label-width="80px">
          <ht-select
            v-model="form.status"
            :options="[{'key': 0, 'value':'禁用'},{'key': 1, 'value':'启用'}]"
            :validate="{'required':true}"
          />
        </ht-form-item>
        <ht-form-item label="角色名称" label-width="80px">
          <ht-input v-model="form.roleName" autocomplete="off" :validate="{required:true}"></ht-input>
        </ht-form-item>
        <ht-form-item label="角色别名" label-width="80px">
          <ht-input v-model="form.roleCode" autocomplete="off" validate="required"></ht-input>
        </ht-form-item>
        <ht-form-item label="角色状态" label-width="80px">
          <ht-select
            v-model="form.status"
            :options="[{'key': 0, 'value':'禁用'},{'key': 1, 'value':'启用'}]"
            :validate="{'required':true}"
          />
        </ht-form-item>
        <ht-form-item label="角色名称" label-width="80px">
          <ht-input v-model="form.roleName" autocomplete="off" :validate="{required:true}"></ht-input>
        </ht-form-item>
        <ht-form-item label="角色别名" label-width="80px">
          <ht-input v-model="form.roleCode" autocomplete="off" validate="required"></ht-input>
        </ht-form-item>
        <ht-form-item label="角色状态" label-width="80px">
          <ht-select
            v-model="form.status"
            :options="[{'key': 0, 'value':'禁用'},{'key': 1, 'value':'启用'}]"
            :validate="{'required':true}"
          />
        </ht-form-item>
      </el-form>
      <div slot="footer" class="dialog-footer">
        <el-button @click="dialogCancle">取 消</el-button>
        <el-button type="primary" @click="dialogSave">保 存</el-button>
        <ht-save-button
          scope-name="editRoleForm"
          :is-submit="isSubmit"
          @before-save-data="beforeSaveData"
        >HtSaveButton</ht-save-button>
        <el-button @click="showDialog2()">侧边嵌套弹窗2</el-button>
      </div>
      <div slot="title">
        <span style="color:red;">我是slot标题，会覆盖title中的设置</span>
      </div>

      <ht-sidebar-dialog
        :width="dialogWidthPrecent2"
        title="侧边弹窗例子-添加角色"
        :visible="dialogVisible2"
        :before-close="handleClose2"
        append-to-body
      >
        <el-form :model="form">
          <ht-form-item label="角色名称" label-width="80px">
            <ht-input v-model="form.roleName" autocomplete="off" :validate="{required:true}"></ht-input>
          </ht-form-item>
          <ht-form-item label="角色别名" label-width="80px">
            <ht-input v-model="form.roleCode" autocomplete="off" validate="required"></ht-input>
          </ht-form-item>
          <ht-form-item label="角色状态" label-width="80px">
            <ht-select
              v-model="form.status"
              :options="[{'key': 0, 'value':'禁用'},{'key': 1, 'value':'启用'}]"
              :validate="{'required':true}"
            />
          </ht-form-item>
        </el-form>
        <div slot="footer" class="dialog-footer">
          <el-button @click="dialogVisible2 = false">取 消</el-button>
          <el-button type="primary" @click="dialogVisible2 = false">保 存</el-button>
        </div>
      </ht-sidebar-dialog>
    </ht-sidebar-dialog>
```