## 头信息

| 字节序  | 类型      |     字段      |
|:----:|---------|:-----------:|
|  0   | INT8    |    消息类型     |
| 1-8  | INT64   |   UTC时间戳    |
| 9-11 | INT16   |    消息序号     |
| 12-n | STRING  |    设备ID     |
| ...  | MESSAGE | 消息类型对应的编码规则 |

## 数据类型

所有数据类型均采用`大端`编码

| Byte |  Type   | 编码规则                                        |
|:----:|:-------:|---------------------------------------------|
| 0x00 |  NULL   | 0x01                                        |
| 0x01 | BOOLEAN | 1字节 0x00为false 其他为true                      |
| 0x02 |  INT8   | 1字节 (byte)                                  |
| 0x03 |  INT16  | 2字节整型 (short)                               |
| 0x04 |  INT32  | 4字节整型 (int)                                 |
| 0x05 |  INT64  | 8字节整型 (long)                                |
| 0x06 |  UINT8  | 1字节无符号整型                                    |
| 0x07 | UINT16  | 2字节无符号整型                                    |
| 0x08 | UINT32  | 4字节无符号整型                                    |
| 0x09 |  FLOAT  | 4字节 IEEE 754浮点数                             |
| 0x0a | DOUBLE  | 8字节 IEEE 754浮点数                             |
| 0x0b | STRING  | 前`2字节无符号整型`表示字符串长度,接下来长度的字节为字符串内容,UTF8编码    |
| 0x0c | BINARY  | 前`2字节无符号整型`表示数据长度,接下来长度的字节为数据内容             |
| 0x0d |  ARRAY  | 前`2字节无符号整型`表述数组长度,接下来根据后续报文类型来解析元素          |
| 0x0e | OBJECT  | 前`2字节无符号整型`表述对象字段长度,接下来根据后续报文类型来解析key value |

## 消息类型定义

| Byte | Type               | 说明     |
|:----:|:-------------------|--------|
| 0x00 | keepalive          | 心跳     |
| 0x01 | online             | 首次连接   |
| 0x02 | ack                | 应答     |
| 0x03 | reportProperty     | 上报属性   |
| 0x04 | readProperty       | 读取属性   |
| 0x05 | readPropertyReply  | 读取属性回复 |
| 0x06 | writeProperty      | 修改属性   |
| 0x07 | writePropertyReply | 修改属性回复 |
| 0x08 | function           | 功能调用   |
| 0x09 | functionReply      | 功能调用回复 |

### 0x00 keepalive 心跳

[ 0x00 ]

### 0x01 online 首次连接

[ 0x01,STRING:密钥信息 ]

### 0x02 ack 应答

[ 0x02,应答码 ]

应答码: 0x00:ok , 0x01: 未认证, 0x02: 不支持.

### 0x03 reportProperty 上报属性

[ 0x03,属性数据:OBJECT类型 ]

### 0x04 readProperty 读取属性

[ 0x04,属性列表:ARRAY类型 ]

### 0x05 readPropertyReply 读取属性回复

读取成功:

[ 0x05,`0x01`,属性数据:OBJECT类型 ]

读取失败:
[ 0x05,`0x00`,错误码:动态类型,错误消息:动态类型 ]

`动态读取`表示类型不确定,根据对应的`数据类型`来定义类型.

如: 无错误信息

[ 0x05,0x00,`0x00`,`0x00` ]

`INT8(0x02)`类型错误码:`0x04`

[ 0x05,0x00,`0x02,0x04`,0x00 ]

TODO 更多消息类型