/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.dashboard.web;

import com.alibaba.fastjson.JSON;
import java.util.Map;
import org.hswebframework.web.authorization.annotation.Authorize;
import org.hswebframework.web.authorization.annotation.QueryAction;
import org.hswebframework.web.authorization.annotation.Resource;
import org.hswebframework.web.exception.NotFoundException;
import org.jetlinks.community.dashboard.DashboardManager;
import org.jetlinks.community.dashboard.DashboardObject;
import org.jetlinks.community.dashboard.MeasurementParameter;
import org.jetlinks.community.dashboard.web.request.DashboardMeasurementRequest;
import org.jetlinks.community.dashboard.web.response.DashboardInfo;
import org.jetlinks.community.dashboard.web.response.DashboardMeasurementResponse;
import org.jetlinks.community.dashboard.web.response.MeasurementInfo;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"/dashboard"})
@Resource(id="dashboard", name="\u4eea\u8868\u76d8")
@Authorize
public class DashboardController {
    private final DashboardManager dashboardManager;

    public DashboardController(DashboardManager dashboardManager) {
        this.dashboardManager = dashboardManager;
    }

    @GetMapping(value={"/defs"})
    @QueryAction
    public Flux<DashboardInfo> getDefinitions() {
        return this.dashboardManager.getDashboards().flatMap(DashboardInfo::of);
    }

    @GetMapping(value={"/def/{dashboard}/{object}/measurements"})
    @QueryAction
    public Flux<MeasurementInfo> getMeasurementDefinitions(@PathVariable String dashboard, @PathVariable String object) {
        return this.dashboardManager.getDashboard(dashboard).flatMap(dash -> dash.getObject(object)).flatMapMany(DashboardObject::getMeasurements).flatMap(MeasurementInfo::of);
    }

    @GetMapping(value={"/{dashboard}/{object}/{measurement}/{dimension}"}, produces={"text/event-stream"})
    @Authorize(merge=false)
    public Flux<Object> getMeasurementValue(@PathVariable String dashboard, @PathVariable String object, @PathVariable String dimension, @PathVariable String measurement, @RequestParam Map<String, Object> params) {
        return this.dashboardManager.getDashboard(dashboard).flatMap(dash -> dash.getObject(object)).flatMap(obj -> obj.getMeasurement(measurement)).flatMap(meas -> meas.getDimension(dimension)).switchIfEmpty(Mono.error(() -> new NotFoundException("\u4e0d\u652f\u6301\u7684\u4eea\u8868\u76d8", new Object[0]))).flatMapMany(dim -> dim.getValue(MeasurementParameter.of(params)));
    }

    @PostMapping(value={"/_multi"})
    @Authorize(merge=false)
    public Flux<DashboardMeasurementResponse> getMultiMeasurementValue(@RequestBody Flux<DashboardMeasurementRequest> requests) {
        return requests.flatMap(request -> this.dashboardManager.getDashboard(request.getDashboard()).flatMap(dash -> dash.getObject(request.getObject())).flatMap(obj -> obj.getMeasurement(request.getMeasurement())).flatMap(meas -> meas.getDimension(request.getDimension())).filter(dim -> !dim.isRealTime()).flatMapMany(dim -> dim.getValue(MeasurementParameter.of(request.getParams()))).map(val -> DashboardMeasurementResponse.of(request.getGroup(), val)));
    }

    @GetMapping(value={"/_multi"}, produces={"text/event-stream"})
    @Authorize(merge=false)
    public Flux<DashboardMeasurementResponse> getMultiMeasurementValue(@RequestParam String requestJson) {
        return Flux.fromIterable((Iterable)JSON.parseArray((String)requestJson, DashboardMeasurementRequest.class)).flatMap(request -> this.dashboardManager.getDashboard(request.getDashboard()).flatMap(dash -> dash.getObject(request.getObject())).flatMap(obj -> obj.getMeasurement(request.getMeasurement())).flatMap(meas -> meas.getDimension(request.getDimension())).flatMapMany(dim -> dim.getValue(MeasurementParameter.of(request.getParams()))).map(val -> DashboardMeasurementResponse.of(request.getGroup(), val)));
    }
}

