/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.dashboard.supports;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetlinks.community.dashboard.DashboardDefinition;
import org.jetlinks.community.dashboard.Measurement;
import org.jetlinks.community.dashboard.ObjectDefinition;
import org.jetlinks.community.dashboard.supports.MeasurementProvider;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class StaticMeasurementProvider
implements MeasurementProvider {
    private Map<String, Measurement> measurements = new ConcurrentHashMap<String, Measurement>();
    private DashboardDefinition dashboardDefinition;
    private ObjectDefinition objectDefinition;

    public StaticMeasurementProvider(DashboardDefinition dashboardDefinition, ObjectDefinition objectDefinition) {
        this.dashboardDefinition = dashboardDefinition;
        this.objectDefinition = objectDefinition;
    }

    protected void addMeasurement(Measurement measurement) {
        this.measurements.put(measurement.getDefinition().getId(), measurement);
    }

    @Override
    public Flux<Measurement> getMeasurements() {
        return Flux.fromIterable(this.measurements.values());
    }

    @Override
    public Mono<Measurement> getMeasurement(String id) {
        return Mono.justOrEmpty((Object)this.measurements.get(id));
    }

    @Override
    public DashboardDefinition getDashboardDefinition() {
        return this.dashboardDefinition;
    }

    @Override
    public ObjectDefinition getObjectDefinition() {
        return this.objectDefinition;
    }
}

